/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.opennlp.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

@ComponentName(value="OpenNLP Named Entity Recognition")
@ComponentDescription(value="Use OpenNLP Named Entity Recognition (NER) models to extract named entities as annotations")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"opennlp", "ner"})
public class NER
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getModel(), settings.getType());
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withProcessesAnnotations("grammar/sentence", SpanBounds.class).withProcessesAnnotations("grammar/wordToken", SpanBounds.class).withCreatesAnnotations(((Settings)this.getSettings()).getType(), SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private File model;
        private String type;

        public boolean validate() {
            return this.model != null;
        }

        @Description(value="OpenNLP NER Model File")
        public File getModel() {
            return this.model;
        }

        public void setModel(File model) {
            this.model = model;
        }

        @Description(value="Entity type")
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private NameFinderME nameFinder;
        private String type;

        public Processor(File model, String type) {
            this.type = type;
            try {
                this.nameFinder = new NameFinderME(new TokenNameFinderModel(model));
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Cannot read NER model", (Throwable)ioe);
            }
        }

        public Processor(InputStream model, String type) {
            this.type = type;
            try {
                this.nameFinder = new NameFinderME(new TokenNameFinderModel(model));
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Cannot read NER model", (Throwable)ioe);
            }
        }

        protected void process(Text content) {
            Stream sentences = content.getAnnotations().getByBoundsAndType(SpanBounds.class, "grammar/sentence");
            sentences.forEach(s -> {
                Span[] spans;
                SpanBounds bounds = (SpanBounds)s.getBounds();
                ArrayList tokens = new ArrayList();
                content.getBetween(bounds.getBegin(), bounds.getEnd()).filter(a -> "grammar/wordToken".equals(a.getType())).filter(a -> a.getBounds() instanceof SpanBounds).sorted(Comparator.comparingInt(a -> ((SpanBounds)a.getBounds()).getBegin())).forEach(a -> tokens.add((SpanBounds)a.getBounds()));
                for (Span span : spans = this.nameFinder.find((String[])tokens.stream().map(b -> (String)b.getData((Content)content).get()).toArray(String[]::new))) {
                    int begin = ((SpanBounds)tokens.get(span.getStart())).getBegin();
                    int end = ((SpanBounds)tokens.get(span.getEnd() - 1)).getEnd();
                    ((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(begin, end)).withType(this.type)).withProperty("probability", (Object)span.getProb())).save();
                }
            });
            this.nameFinder.clearAdaptiveData();
        }

        public void close() {
            this.nameFinder = null;
        }
    }
}

