/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.conventions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class PathUtils {
    public static final String SEPARATOR = "/";

    private PathUtils() {
    }

    public static String join(String ... parts) {
        return PathUtils.join(Stream.of(parts));
    }

    public static String join(Iterable<String> iterable) {
        return PathUtils.join(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static String join(Iterator<String> iterator) {
        return PathUtils.join(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public static String join(Stream<String> stream) {
        return stream.filter(Objects::nonNull).collect(Collectors.joining(SEPARATOR));
    }

    public static String[] split(String path) {
        List<String> l = PathUtils.splitToList(path);
        return l.toArray(new String[l.size()]);
    }

    public static Iterable<String> splitToIterable(String path) {
        return PathUtils.splitToList(path);
    }

    public static Stream<String> splitToStream(String path) {
        return PathUtils.splitToList(path).stream();
    }

    public static List<String> splitToList(String path) {
        return Arrays.stream(path.split(SEPARATOR)).filter(s -> !s.isEmpty()).map(String::trim).collect(Collectors.toList());
    }
}

