/*
 * Decompiled with CFR 0.152.
 */
package io.appwrite.cookies;

import android.os.Build;
import android.webkit.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"removeAll", "", "Landroid/webkit/CookieManager;", "syncToWebKitCookieManager", "Ljava/net/CookieStore;", "toSetCookieString", "", "Ljava/net/HttpCookie;", "library_release"})
public final class ExtensionsKt {
    @NotNull
    public static final String toSetCookieString(@NotNull HttpCookie $this$toSetCookieString) {
        String secure;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toSetCookieString, (String)"<this>");
        if ($this$toSetCookieString.getMaxAge() != -1L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.UK);
            boolean bl = false;
            boolean bl2 = false;
            SimpleDateFormat $this$toSetCookieString_u24lambda_u2d0 = simpleDateFormat;
            boolean bl3 = false;
            $this$toSetCookieString_u24lambda_u2d0.setTimeZone(TimeZone.getTimeZone("GMT"));
            SimpleDateFormat dateFormat = simpleDateFormat;
            Calendar calendar = Calendar.getInstance(Locale.UK);
            bl2 = false;
            boolean bl4 = false;
            Calendar $this$toSetCookieString_u24lambda_u2d1 = calendar;
            boolean bl5 = false;
            $this$toSetCookieString_u24lambda_u2d1.set(13, (int)$this$toSetCookieString.getMaxAge());
            Calendar calendar2 = calendar;
            string = Intrinsics.stringPlus((String)"; expires=", (Object)dateFormat.format(calendar2.getTime()));
        } else {
            string = "";
        }
        String expires = string;
        String path = $this$toSetCookieString.getPath() != null ? Intrinsics.stringPlus((String)"; path=", (Object)$this$toSetCookieString.getPath()) : "";
        String domain = $this$toSetCookieString.getDomain() != null ? Intrinsics.stringPlus((String)"; domain=", (Object)$this$toSetCookieString.getDomain()) : "";
        String string2 = secure = $this$toSetCookieString.getSecure() ? "; secure" : "";
        String httpOnly = Build.VERSION.SDK_INT >= 24 ? ($this$toSetCookieString.isHttpOnly() ? "; httponly" : "") : "";
        return $this$toSetCookieString.getName() + '=' + $this$toSetCookieString.getValue() + expires + path + domain + secure + httpOnly;
    }

    public static final synchronized void syncToWebKitCookieManager(@NotNull CookieStore $this$syncToWebKitCookieManager) {
        Intrinsics.checkNotNullParameter((Object)$this$syncToWebKitCookieManager, (String)"<this>");
        CookieManager webKitCookieManager = CookieManager.getInstance();
        List<HttpCookie> list2 = $this$syncToWebKitCookieManager.getCookies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"cookies");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpCookie it = (HttpCookie)element$iv;
            boolean bl = false;
            String hostUrl = (it.getSecure() ? "https" : "http") + "://" + it.getDomain();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            webKitCookieManager.setCookie(hostUrl, ExtensionsKt.toSetCookieString(it));
        }
        webKitCookieManager.flush();
    }

    public static final synchronized void removeAll(@NotNull CookieManager $this$removeAll) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAll, (String)"<this>");
        $this$removeAll.removeAllCookies(null);
        $this$removeAll.flush();
    }
}

