package io.appwrite.models

import com.google.gson.annotations.SerializedName

/**
 * Session
 */
data class Session(
    /**
     * Session ID.
     *
     */
    @SerializedName("\$id")
    val id: String,

    /**
     * Session creation date in Unix timestamp.
     *
     */
    @SerializedName("\$createdAt")
    val createdAt: Long,

    /**
     * User ID.
     *
     */
    @SerializedName("userId")
    val userId: String,

    /**
     * Session expiration date in Unix timestamp.
     *
     */
    @SerializedName("expire")
    val expire: Long,

    /**
     * Session Provider.
     *
     */
    @SerializedName("provider")
    val provider: String,

    /**
     * Session Provider User ID.
     *
     */
    @SerializedName("providerUid")
    val providerUid: String,

    /**
     * Session Provider Access Token.
     *
     */
    @SerializedName("providerAccessToken")
    val providerAccessToken: String,

    /**
     * Date, the Unix timestamp of when the access token expires.
     *
     */
    @SerializedName("providerAccessTokenExpiry")
    val providerAccessTokenExpiry: Long,

    /**
     * Session Provider Refresh Token.
     *
     */
    @SerializedName("providerRefreshToken")
    val providerRefreshToken: String,

    /**
     * IP in use when the session was created.
     *
     */
    @SerializedName("ip")
    val ip: String,

    /**
     * Operating system code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/os.json).
     *
     */
    @SerializedName("osCode")
    val osCode: String,

    /**
     * Operating system name.
     *
     */
    @SerializedName("osName")
    val osName: String,

    /**
     * Operating system version.
     *
     */
    @SerializedName("osVersion")
    val osVersion: String,

    /**
     * Client type.
     *
     */
    @SerializedName("clientType")
    val clientType: String,

    /**
     * Client code name. View list of [available options](https://github.com/appwrite/appwrite/blob/master/docs/lists/clients.json).
     *
     */
    @SerializedName("clientCode")
    val clientCode: String,

    /**
     * Client name.
     *
     */
    @SerializedName("clientName")
    val clientName: String,

    /**
     * Client version.
     *
     */
    @SerializedName("clientVersion")
    val clientVersion: String,

    /**
     * Client engine name.
     *
     */
    @SerializedName("clientEngine")
    val clientEngine: String,

    /**
     * Client engine name.
     *
     */
    @SerializedName("clientEngineVersion")
    val clientEngineVersion: String,

    /**
     * Device name.
     *
     */
    @SerializedName("deviceName")
    val deviceName: String,

    /**
     * Device brand name.
     *
     */
    @SerializedName("deviceBrand")
    val deviceBrand: String,

    /**
     * Device model name.
     *
     */
    @SerializedName("deviceModel")
    val deviceModel: String,

    /**
     * Country two-character ISO 3166-1 alpha code.
     *
     */
    @SerializedName("countryCode")
    val countryCode: String,

    /**
     * Country name.
     *
     */
    @SerializedName("countryName")
    val countryName: String,

    /**
     * Returns true if this the current user session.
     *
     */
    @SerializedName("current")
    val current: Boolean
) {
    companion object {
        @Suppress("UNCHECKED_CAST")
        fun from(map: Map<String, Any>) = Session(
            id = map["\$id"] as String,
            createdAt = (map["\$createdAt"] as Number).toLong(),
            userId = map["userId"] as String,
            expire = (map["expire"] as Number).toLong(),
            provider = map["provider"] as String,
            providerUid = map["providerUid"] as String,
            providerAccessToken = map["providerAccessToken"] as String,
            providerAccessTokenExpiry = (map["providerAccessTokenExpiry"] as Number).toLong(),
            providerRefreshToken = map["providerRefreshToken"] as String,
            ip = map["ip"] as String,
            osCode = map["osCode"] as String,
            osName = map["osName"] as String,
            osVersion = map["osVersion"] as String,
            clientType = map["clientType"] as String,
            clientCode = map["clientCode"] as String,
            clientName = map["clientName"] as String,
            clientVersion = map["clientVersion"] as String,
            clientEngine = map["clientEngine"] as String,
            clientEngineVersion = map["clientEngineVersion"] as String,
            deviceName = map["deviceName"] as String,
            deviceBrand = map["deviceBrand"] as String,
            deviceModel = map["deviceModel"] as String,
            countryCode = map["countryCode"] as String,
            countryName = map["countryName"] as String,
            current = map["current"] as Boolean
        )
    }

    fun toMap(): Map<String, Any> = mapOf(
        "\$id" to id as Any,
        "\$createdAt" to createdAt as Any,
        "userId" to userId as Any,
        "expire" to expire as Any,
        "provider" to provider as Any,
        "providerUid" to providerUid as Any,
        "providerAccessToken" to providerAccessToken as Any,
        "providerAccessTokenExpiry" to providerAccessTokenExpiry as Any,
        "providerRefreshToken" to providerRefreshToken as Any,
        "ip" to ip as Any,
        "osCode" to osCode as Any,
        "osName" to osName as Any,
        "osVersion" to osVersion as Any,
        "clientType" to clientType as Any,
        "clientCode" to clientCode as Any,
        "clientName" to clientName as Any,
        "clientVersion" to clientVersion as Any,
        "clientEngine" to clientEngine as Any,
        "clientEngineVersion" to clientEngineVersion as Any,
        "deviceName" to deviceName as Any,
        "deviceBrand" to deviceBrand as Any,
        "deviceModel" to deviceModel as Any,
        "countryCode" to countryCode as Any,
        "countryName" to countryName as Any,
        "current" to current as Any
    )
}