package `arrow`.`generic`

import arrow.typeclasses.*
import arrow.core.*
import arrow.instances.*


fun `arrow`.`generic`.`Car`.combine(other: `arrow`.`generic`.`Car`): `arrow`.`generic`.`Car` =
  this + other

fun List<`arrow`.`generic`.`Car`>.combineAll(): `arrow`.`generic`.`Car` =
  this.reduce { a, b -> a + b }

operator fun `arrow`.`generic`.`Car`.plus(other: `arrow`.`generic`.`Car`): `arrow`.`generic`.`Car` =
  with(`arrow`.`generic`.`Car`.semigroup()) { this@plus.combine(other) }


fun emptyCar(): `arrow`.`generic`.`Car` =
  `arrow`.`generic`.`Car`.monoid().empty()





fun `arrow`.`generic`.`Car`.toHList(): arrow.generic.HList1<`arrow`.`generic`.`Speed`> =
  arrow.generic.hListOf(this.`speed`)

fun arrow.generic.HList1<`arrow`.`generic`.`Speed`>.toCar(): `arrow`.`generic`.`Car` =
  `arrow`.`generic`.`Car`(this.head)

fun `arrow`.`generic`.`Car`.toHListLabeled(): arrow.generic.HList1<arrow.core.Tuple2<String, `arrow`.`generic`.`Speed`>> =
  arrow.generic.hListOf(("speed" toT speed))





interface CarSemigroupInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Car`> {
  override fun `arrow`.`generic`.`Car`.combine(b: `arrow`.`generic`.`Car`): `arrow`.`generic`.`Car` {
    val (xA) = this
    val (yA) = b
    return `arrow`.`generic`.`Car`(with(`arrow`.`generic`.`Speed`.semigroup()){ xA.combine(yA) })
  }

  companion object {
    val defaultInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Car`> =
      object : CarSemigroupInstance {}
  }
}

fun `arrow`.`generic`.`Car`.Companion.semigroup(): arrow.typeclasses.Semigroup<`arrow`.`generic`.`Car`> =
  CarSemigroupInstance.defaultInstance



interface CarMonoidInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Car`>, CarSemigroupInstance {
  override fun empty(): `arrow`.`generic`.`Car` =
    `arrow`.`generic`.`Car`(with(`arrow`.`generic`.`Speed`.monoid()){ empty() })

    companion object {
       val defaultInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Car`> =
           object : CarMonoidInstance {}
    }
}

fun `arrow`.`generic`.`Car`.Companion.monoid(): arrow.typeclasses.Monoid<`arrow`.`generic`.`Car`> =
  CarMonoidInstance.defaultInstance



interface CarEqInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Car`> {
  override fun `arrow`.`generic`.`Car`.eqv(b: `arrow`.`generic`.`Car`): Boolean =
    this == b

  companion object {
    val defaultInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Car`> =
           object : CarEqInstance {}
  }
}

fun `arrow`.`generic`.`Car`.Companion.eq(): arrow.typeclasses.Eq<`arrow`.`generic`.`Car`> =
  CarEqInstance.defaultInstance


interface CarShowInstance : arrow.typeclasses.Show<`arrow`.`generic`.`Car`> {
  override fun `arrow`.`generic`.`Car`.show(): String =
    this.toString()
}

fun `arrow`.`generic`.`Car`.Companion.show(): arrow.typeclasses.Show<`arrow`.`generic`.`Car`> =
  object : CarShowInstance {}


