package `arrow`.`generic`

import arrow.typeclasses.*
import arrow.core.*
import arrow.instances.*


fun `arrow`.`generic`.`Speed`.combine(other: `arrow`.`generic`.`Speed`): `arrow`.`generic`.`Speed` =
  this + other

fun List<`arrow`.`generic`.`Speed`>.combineAll(): `arrow`.`generic`.`Speed` =
  this.reduce { a, b -> a + b }

operator fun `arrow`.`generic`.`Speed`.plus(other: `arrow`.`generic`.`Speed`): `arrow`.`generic`.`Speed` =
  with(`arrow`.`generic`.`Speed`.semigroup()) { this@plus.combine(other) }


fun emptySpeed(): `arrow`.`generic`.`Speed` =
  `arrow`.`generic`.`Speed`.monoid().empty()





fun `arrow`.`generic`.`Speed`.toHList(): arrow.generic.HList1<`kotlin`.`Int`> =
  arrow.generic.hListOf(this.`kmh`)

fun arrow.generic.HList1<`kotlin`.`Int`>.toSpeed(): `arrow`.`generic`.`Speed` =
  `arrow`.`generic`.`Speed`(this.head)

fun `arrow`.`generic`.`Speed`.toHListLabeled(): arrow.generic.HList1<arrow.core.Tuple2<String, `kotlin`.`Int`>> =
  arrow.generic.hListOf(("kmh" toT kmh))





interface SpeedSemigroupInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Speed`> {
  override fun `arrow`.`generic`.`Speed`.combine(b: `arrow`.`generic`.`Speed`): `arrow`.`generic`.`Speed` {
    val (xA) = this
    val (yA) = b
    return `arrow`.`generic`.`Speed`(with(`kotlin`.`Int`.semigroup()){ xA.combine(yA) })
  }

  companion object {
    val defaultInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Speed`> =
      object : SpeedSemigroupInstance {}
  }
}

fun `arrow`.`generic`.`Speed`.Companion.semigroup(): arrow.typeclasses.Semigroup<`arrow`.`generic`.`Speed`> =
  SpeedSemigroupInstance.defaultInstance



interface SpeedMonoidInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Speed`>, SpeedSemigroupInstance {
  override fun empty(): `arrow`.`generic`.`Speed` =
    `arrow`.`generic`.`Speed`(with(`kotlin`.`Int`.monoid()){ empty() })

    companion object {
       val defaultInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Speed`> =
           object : SpeedMonoidInstance {}
    }
}

fun `arrow`.`generic`.`Speed`.Companion.monoid(): arrow.typeclasses.Monoid<`arrow`.`generic`.`Speed`> =
  SpeedMonoidInstance.defaultInstance



interface SpeedEqInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Speed`> {
  override fun `arrow`.`generic`.`Speed`.eqv(b: `arrow`.`generic`.`Speed`): Boolean =
    this == b

  companion object {
    val defaultInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Speed`> =
           object : SpeedEqInstance {}
  }
}

fun `arrow`.`generic`.`Speed`.Companion.eq(): arrow.typeclasses.Eq<`arrow`.`generic`.`Speed`> =
  SpeedEqInstance.defaultInstance


interface SpeedShowInstance : arrow.typeclasses.Show<`arrow`.`generic`.`Speed`> {
  override fun `arrow`.`generic`.`Speed`.show(): String =
    this.toString()
}

fun `arrow`.`generic`.`Speed`.Companion.show(): arrow.typeclasses.Show<`arrow`.`generic`.`Speed`> =
  object : SpeedShowInstance {}


