package `arrow`.`generic`

import arrow.typeclasses.*
import arrow.core.*
import arrow.instances.*
import arrow.instances.option.monoid.monoid
import arrow.instances.option.semigroup.semigroup


fun `arrow`.`generic`.`Account`.combine(other: `arrow`.`generic`.`Account`): `arrow`.`generic`.`Account` =
  this + other

fun List<`arrow`.`generic`.`Account`>.combineAll(): `arrow`.`generic`.`Account` =
  this.reduce { a, b -> a + b }

operator fun `arrow`.`generic`.`Account`.plus(other: `arrow`.`generic`.`Account`): `arrow`.`generic`.`Account` =
  with(`arrow`.`generic`.`Account`.semigroup()) { this@plus.combine(other) }


fun emptyAccount(): `arrow`.`generic`.`Account` =
  `arrow`.`generic`.`Account`.monoid().empty()



fun `arrow`.`generic`.`Account`.tupled(): arrow.core.Tuple2<`kotlin`.`Int`, `kotlin`.`Int`> =
 arrow.core.Tuple2(this.`balance`, this.`available`)

fun `arrow`.`generic`.`Account`.tupledLabeled(): arrow.core.Tuple2<arrow.core.Tuple2<String, `kotlin`.`Int`>, arrow.core.Tuple2<String, `kotlin`.`Int`>> =
  arrow.core.Tuple2(("balance" toT balance), ("available" toT available))

fun <B> `arrow`.`generic`.`Account`.foldLabeled(f: (arrow.core.Tuple2<kotlin.String, `kotlin`.`Int`>, arrow.core.Tuple2<kotlin.String, `kotlin`.`Int`>) -> B): B {
  val t = tupledLabeled()
  return f(t.a, t.b)
}

fun arrow.core.Tuple2<`kotlin`.`Int`, `kotlin`.`Int`>.toAccount(): `arrow`.`generic`.`Account` =
  `arrow`.`generic`.`Account`(this.a, this.b)



fun `arrow`.`generic`.`Account`.toHList(): arrow.generic.HList2<`kotlin`.`Int`, `kotlin`.`Int`> =
  arrow.generic.hListOf(this.`balance`, this.`available`)

fun arrow.generic.HList2<`kotlin`.`Int`, `kotlin`.`Int`>.toAccount(): `arrow`.`generic`.`Account` =
  `arrow`.`generic`.`Account`(this.head, this.tail.head)

fun `arrow`.`generic`.`Account`.toHListLabeled(): arrow.generic.HList2<arrow.core.Tuple2<String, `kotlin`.`Int`>, arrow.core.Tuple2<String, `kotlin`.`Int`>> =
  arrow.generic.hListOf(("balance" toT balance), ("available" toT available))



fun <F> arrow.typeclasses.Applicative<F>.mapToAccount(balance: arrow.Kind<F, `kotlin`.`Int`>, available: arrow.Kind<F, `kotlin`.`Int`>): arrow.Kind<F, `arrow`.`generic`.`Account`> =
    this.map(balance, available, { it.toAccount() })




interface AccountSemigroupInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Account`> {
  override fun `arrow`.`generic`.`Account`.combine(b: `arrow`.`generic`.`Account`): `arrow`.`generic`.`Account` {
    val (xA, xB) = this
    val (yA, yB) = b
    return `arrow`.`generic`.`Account`(with(`kotlin`.`Int`.semigroup()){ xA.combine(yA) }, with(`kotlin`.`Int`.semigroup()){ xB.combine(yB) })
  }

  companion object {
    val defaultInstance : arrow.typeclasses.Semigroup<`arrow`.`generic`.`Account`> =
      object : AccountSemigroupInstance {}
  }
}

fun `arrow`.`generic`.`Account`.Companion.semigroup(): arrow.typeclasses.Semigroup<`arrow`.`generic`.`Account`> =
  AccountSemigroupInstance.defaultInstance



interface AccountMonoidInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Account`>, AccountSemigroupInstance {
  override fun empty(): `arrow`.`generic`.`Account` =
    `arrow`.`generic`.`Account`(with(`kotlin`.`Int`.monoid()){ empty() }, with(`kotlin`.`Int`.monoid()){ empty() })

    companion object {
       val defaultInstance : arrow.typeclasses.Monoid<`arrow`.`generic`.`Account`> =
           object : AccountMonoidInstance {}
    }
}

fun `arrow`.`generic`.`Account`.Companion.monoid(): arrow.typeclasses.Monoid<`arrow`.`generic`.`Account`> =
  AccountMonoidInstance.defaultInstance



interface AccountEqInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Account`> {
  override fun `arrow`.`generic`.`Account`.eqv(b: `arrow`.`generic`.`Account`): Boolean =
    this == b

  companion object {
    val defaultInstance : arrow.typeclasses.Eq<`arrow`.`generic`.`Account`> =
           object : AccountEqInstance {}
  }
}

fun `arrow`.`generic`.`Account`.Companion.eq(): arrow.typeclasses.Eq<`arrow`.`generic`.`Account`> =
  AccountEqInstance.defaultInstance


interface AccountShowInstance : arrow.typeclasses.Show<`arrow`.`generic`.`Account`> {
  override fun `arrow`.`generic`.`Account`.show(): String =
    this.toString()
}

fun `arrow`.`generic`.`Account`.Companion.show(): arrow.typeclasses.Show<`arrow`.`generic`.`Account`> =
  object : AccountShowInstance {}


