/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringSimpleFieldActions;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.LowercaseChar;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import io.atlasmap.v2.UppercaseChar;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class StringSimpleFieldActionsTest {
    @Test
    public void testCapitalize() {
        Assert.assertNull((Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)""));
        Assert.assertEquals((Object)" foo ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)" foo "));
        Assert.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"   Foo"));
        Assert.assertEquals((Object)"FOo   ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"fOo   "));
        Assert.assertEquals((Object)"    foO   ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"    foO   "));
        Assert.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"\t\n   FOO"));
        Assert.assertEquals((Object)"\t\n   FOO\f\r", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testFileExtension() {
        Assert.assertNull((Object)StringSimpleFieldActions.fileExtension(null, null));
        Assert.assertNull((Object)StringSimpleFieldActions.fileExtension(null, (String)""));
        Assert.assertNull((Object)StringSimpleFieldActions.fileExtension(null, (String)"foo"));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, (String)"."));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo."));
        Assert.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo.bar"));
        Assert.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo.foo.bar"));
    }

    @Test
    public void testLowerCase() {
        Assert.assertNull((Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)""));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"foo"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"Foo"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"fOo"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"foO"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"FOO"));
        Assert.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"FOO BAR"));
    }

    @Test
    public void testLowerCaseChar() {
        Assert.assertNull((Object)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), null));
        Assert.assertEquals((long)0L, (long)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('\u0000')).charValue());
        Assert.assertEquals((long)102L, (long)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('f')).charValue());
        Assert.assertEquals((long)102L, (long)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('F')).charValue());
    }

    @Test
    public void testNormalize() {
        Assert.assertNull((Object)StringSimpleFieldActions.normalize(null, null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.normalize(null, (String)""));
        Assert.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.normalize(null, (String)" foo bar "));
        Assert.assertEquals((Object)"Foo Bar", (Object)StringSimpleFieldActions.normalize(null, (String)"   Foo Bar   "));
        Assert.assertEquals((Object)"fOo bar", (Object)StringSimpleFieldActions.normalize(null, (String)"fOo   bar"));
        Assert.assertEquals((Object)"foO bar", (Object)StringSimpleFieldActions.normalize(null, (String)"    foO   bar   "));
        Assert.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, (String)"\t\n   FOO \f\t BAR "));
        Assert.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, (String)"\t\n   FOO \f\r BAR\f\r"));
    }

    @Test
    public void testRemoveFileExtension() {
        Assert.assertNull((Object)StringSimpleFieldActions.removeFileExtension(null, null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)""));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo"));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"."));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo."));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo.bar"));
        Assert.assertEquals((Object)"foo.foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo.foo.bar"));
    }

    @Test
    public void testSeparateByDash() {
        Assert.assertNull((Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)""));
        Assert.assertEquals((Object)"-", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"-"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo"));
        Assert.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo bar"));
        Assert.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo+bar"));
        Assert.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo=bar"));
        Assert.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo:bar"));
        Assert.assertEquals((Object)"f-o-o-b-a-r", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"f:o:o:b:a:r"));
    }

    @Test
    public void testSeparateByUnderscore() {
        Assert.assertNull((Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)""));
        Assert.assertEquals((Object)"_", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"-"));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo"));
        Assert.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo bar"));
        Assert.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo+bar"));
        Assert.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo=bar"));
        Assert.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo:bar"));
        Assert.assertEquals((Object)"f_o_o_b_a_r", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"f:o:o:b:a:r"));
    }

    @Test
    public void testSeparatorRegex() {
        Pattern pattern = Pattern.compile("[\\s+\\:\\_\\+\\=\\-]+");
        Assert.assertFalse((boolean)pattern.matcher("foo").find());
        Assert.assertFalse((boolean)pattern.matcher("").find());
        Assert.assertTrue((boolean)pattern.matcher("f o").find());
        Assert.assertTrue((boolean)pattern.matcher("f+o").find());
        Assert.assertTrue((boolean)pattern.matcher("f=o").find());
        Assert.assertTrue((boolean)pattern.matcher("f_o").find());
        Assert.assertTrue((boolean)pattern.matcher("f:o").find());
        Assert.assertTrue((boolean)pattern.matcher("f:o:o").find());
        Assert.assertTrue((boolean)pattern.matcher("f  o").find());
    }

    @Test
    public void testTrim() {
        Assert.assertNull((Object)StringSimpleFieldActions.trim((Trim)new Trim(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)""));
        Assert.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)" foo "));
        Assert.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"   Foo"));
        Assert.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"fOo   "));
        Assert.assertEquals((Object)"foO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"    foO   "));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"\t\n   FOO"));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimLeft() {
        Assert.assertNull((Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)""));
        Assert.assertEquals((Object)"foo ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)" foo "));
        Assert.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"   Foo"));
        Assert.assertEquals((Object)"fOo   ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"fOo   "));
        Assert.assertEquals((Object)"foO   ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"    foO   "));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"\t\n   FOO"));
        Assert.assertEquals((Object)"FOO\f\r", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimRight() {
        Assert.assertNull((Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)""));
        Assert.assertEquals((Object)" foo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)" foo "));
        Assert.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"   Foo"));
        Assert.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"fOo   "));
        Assert.assertEquals((Object)"    foO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"    foO   "));
        Assert.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"\t\n   FOO"));
        Assert.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testUpperCase() {
        Assert.assertNull((Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), null));
        Assert.assertEquals((Object)"", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)""));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foo"));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"Foo"));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"fOo"));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foO"));
        Assert.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"FOO"));
        Assert.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foo bar"));
    }

    @Test
    public void testUpperCaseChar() {
        Assert.assertNull((Object)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), null));
        Assert.assertEquals((long)0L, (long)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('\u0000')).charValue());
        Assert.assertEquals((long)70L, (long)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('f')).charValue());
        Assert.assertEquals((long)70L, (long)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('F')).charValue());
    }
}

