/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.BooleanConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class BooleanConverterTest {
    private BooleanConverter converter = new BooleanConverter();

    @Test
    public void convertToBoolean() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Boolean t2 = this.converter.toBoolean(t, null, null);
        Boolean f2 = this.converter.toBoolean(f, null, null);
        Assert.assertNotNull((Object)t2);
        Assert.assertEquals((Object)t2, (Object)t);
        Assert.assertTrue((boolean)t2);
        Assert.assertNotNull((Object)f2);
        Assert.assertEquals((Object)f2, (Object)f);
        Assert.assertFalse((boolean)f2);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean t = null;
        Boolean t2 = this.converter.toBoolean(t, null, null);
        Assert.assertNull((Object)t2);
    }

    @Test
    public void convertToByte() {
        Byte trueValue = 1;
        Assert.assertEquals((Object)trueValue, (Object)this.converter.toByte(Boolean.TRUE));
        Byte falseValue = 0;
        Assert.assertEquals((Object)falseValue, (Object)this.converter.toByte(Boolean.FALSE));
    }

    @Test
    public void convertToByteNull() {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Character c = this.converter.toCharacter(t);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.charValue());
        c = this.converter.toCharacter(f);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)0L, (long)c.charValue());
    }

    @Test
    public void convertToCharacterNull() {
        Boolean t = null;
        Character c = this.converter.toCharacter(t);
        Assert.assertNull((Object)c);
    }

    @Test
    public void convertToDouble() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Double d = this.converter.toDouble(t);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)1.0, (double)d, (double)0.0);
        d = this.converter.toDouble(f);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Boolean t = null;
        Double d = this.converter.toDouble(t);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Float aFloat = this.converter.toFloat(t);
        Assert.assertNotNull((Object)aFloat);
        Assert.assertEquals((float)1.0f, (float)aFloat.floatValue(), (float)0.0f);
        aFloat = this.converter.toFloat(f);
        Assert.assertNotNull((Object)aFloat);
        Assert.assertEquals((float)0.0f, (float)aFloat.floatValue(), (float)0.0f);
    }

    @Test
    public void convertToFloatNull() {
        Boolean t = null;
        Float f = this.converter.toFloat(t);
        Assert.assertNull((Object)f);
    }

    @Test
    public void convertToInteger() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Integer i = this.converter.toInteger(t);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((long)1L, (long)i.intValue());
        i = this.converter.toInteger(f);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((long)0L, (long)i.intValue());
    }

    @Test
    public void convertToIntegerNull() {
        Boolean t = null;
        Integer i = this.converter.toInteger(t);
        Assert.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Long l = this.converter.toLong(t);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l);
        l = this.converter.toLong(f);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l);
    }

    @Test
    public void convertToLongNull() {
        Boolean t = null;
        Long l = this.converter.toLong(t);
        Assert.assertNull((Object)l);
    }

    @Test
    public void convertToShort() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Short s = this.converter.toShort(t);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)1L, (long)s.shortValue());
        s = this.converter.toShort(f);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)0L, (long)s.shortValue());
    }

    @Test
    public void convertToShortNull() {
        Boolean t = null;
        Short s = this.converter.toShort(t);
        Assert.assertNull((Object)s);
    }

    @Test
    public void convertToString() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        String s = this.converter.toString(t, null, null);
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)"true".equals(s));
        s = this.converter.toString(f, null, null);
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)"false".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Boolean t = null;
        String s = this.converter.toString(t, null, null);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<BooleanConverter> aClass = BooleanConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.BOOLEAN) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

