/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.FloatConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class FloatConverterTest {
    private FloatConverter converter = new FloatConverter();

    @Test
    public void convertToBoolean() {
        Float df = Float.valueOf(0.0f);
        Float dt = Float.valueOf(1.0f);
        Boolean b = this.converter.toBoolean(dt);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(df);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Float df = null;
        Boolean b = this.converter.toBoolean(df);
        Assert.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Float dt = Float.valueOf(-1.0f);
        Boolean b = this.converter.toBoolean(dt);
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Float df = Float.valueOf(0.0f);
        Byte value = 0;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(df));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteOutOfRange() throws Exception {
        Float df = Float.valueOf(Float.MAX_VALUE);
        this.converter.toByte(df);
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Float df = Float.valueOf(0.0f);
        Character c = this.converter.toCharacter(df);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)0L, (long)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Float df = null;
        Character c = this.converter.toCharacter(df);
        Assert.assertNull((Object)c);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterMAX() throws Exception {
        Float df = Float.valueOf(Float.MAX_VALUE);
        this.converter.toCharacter(df);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterMIN() throws Exception {
        Float df = Float.valueOf(-1.0f);
        this.converter.toCharacter(df);
    }

    @Test
    public void convertToDouble() {
        Float df = Float.valueOf(0.0f);
        Double d = this.converter.toDouble(df);
        Assert.assertNotNull((Object)d);
        Assert.assertNotSame((Object)df, (Object)d);
        Assert.assertEquals((double)0.0, (double)d.floatValue(), (double)0.0);
        df = Float.valueOf(1.0f);
        d = this.converter.toDouble(df);
        Assert.assertNotNull((Object)d);
        Assert.assertNotSame((Object)df, (Object)d);
        Assert.assertEquals((double)1.0, (double)d.floatValue(), (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Float df = null;
        Double d = this.converter.toDouble(df);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Float df = Float.valueOf(0.0f);
        Float d = this.converter.toFloat(df);
        Assert.assertNotNull((Object)d);
        Assert.assertNotSame((Object)df, (Object)d);
        Assert.assertEquals((double)0.0, (double)d.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Float df = null;
        Float d = this.converter.toFloat(df);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToInteger() throws Exception {
        Float df = Float.valueOf(0.15f);
        Integer i = this.converter.toInteger(df);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Float df = null;
        Integer i = this.converter.toInteger(df);
        Assert.assertNull((Object)i);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerExceptionMAX() throws Exception {
        Float df = Float.valueOf(Float.MAX_VALUE);
        this.converter.toInteger(df);
    }

    @Test
    public void convertToLong() throws Exception {
        Float df = Float.valueOf(0.0f);
        Long l = this.converter.toLong(df);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)0.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() throws Exception {
        Float df = null;
        Long l = this.converter.toLong(df);
        Assert.assertNull((Object)l);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToLongExceptionMAX() throws Exception {
        Float df = Float.valueOf(Float.MAX_VALUE);
        this.converter.toLong(df);
    }

    @Test
    public void convertToShort() throws Exception {
        Float df = Float.valueOf(0.0f);
        Short s = this.converter.toShort(df);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Float df = null;
        Short s = this.converter.toShort(df);
        Assert.assertNull((Object)s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortExceptionMAX() throws Exception {
        Float df = Float.valueOf(Float.MAX_VALUE);
        this.converter.toShort(df);
    }

    @Test
    public void convertToString() {
        Float df = Float.valueOf(0.0f);
        String s = this.converter.toString(df);
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)"0.0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Float df = null;
        String s = this.converter.toString(df);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<FloatConverter> aClass = FloatConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.FLOAT) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

