/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.LongConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class LongConverterTest {
    private LongConverter converter = new LongConverter();

    @Test
    public void convertToBoolean() {
        Long aLong = 0L;
        Long l = 1L;
        Boolean b = this.converter.toBoolean(l);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(aLong);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Long l = null;
        Boolean b = this.converter.toBoolean(l);
        Assert.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Long dt = -1L;
        Boolean b = this.converter.toBoolean(dt);
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Long l = 0L;
        Byte value = 0;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(l));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteOutOfRange() throws Exception {
        this.converter.toByte(Long.valueOf(Long.MAX_VALUE));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Long l = 0L;
        Character c = this.converter.toCharacter(l);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)0L, (long)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Long l = null;
        Character c = this.converter.toCharacter(l);
        Assert.assertNull((Object)c);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterMAX() throws Exception {
        Long l = Long.MAX_VALUE;
        this.converter.toCharacter(l);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterMIN() throws Exception {
        Long l = -1L;
        this.converter.toCharacter(l);
    }

    @Test
    public void toDate() throws Exception {
        Date date = this.converter.toDate(Long.valueOf(Long.MAX_VALUE));
        Assert.assertNotNull((Object)date);
        date = this.converter.toDate(Long.valueOf(Long.MIN_VALUE));
        Assert.assertNotNull((Object)date);
        date = this.converter.toDate(Long.valueOf(Long.parseLong("0")));
        Assert.assertTrue((boolean)date.toInstant().toString().equals("1970-01-01T00:00:00Z"));
    }

    @Test
    public void convertToDouble() {
        Long l = 0L;
        Double d = this.converter.toDouble(l);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Long l = null;
        Double d = this.converter.toDouble(l);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() {
        Long l = Long.MAX_VALUE;
        Double d = this.converter.toDouble(l);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToFloat() {
        Long l = 0L;
        Float f = this.converter.toFloat(l);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
        l = 1L;
        f = this.converter.toFloat(l);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assert.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() {
        Long l = Long.MAX_VALUE;
        Float f = this.converter.toFloat(l);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() throws Exception {
        Long l = 0L;
        Integer i = this.converter.toInteger(l);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerMAX() throws Exception {
        this.converter.toInteger(Long.valueOf(Long.MAX_VALUE));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerMIN() throws Exception {
        this.converter.toInteger(Long.valueOf(Long.MIN_VALUE));
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Long l = null;
        Integer i = this.converter.toInteger(l);
        Assert.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Long l = 1L;
        Long d = this.converter.toLong(l);
        Assert.assertNotNull((Object)d);
        Assert.assertNotSame((Object)l, (Object)d);
        Assert.assertEquals((double)1.0, (double)d.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Long l = null;
        Long d = this.converter.toLong(l);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToShort() throws Exception {
        Long l = 0L;
        Short s = this.converter.toShort(l);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Long l = null;
        Short s = this.converter.toShort(l);
        Assert.assertNull((Object)s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortExceptionMAX() throws Exception {
        Long l = Long.MAX_VALUE;
        this.converter.toShort(l);
    }

    @Test
    public void convertToString() {
        Long l = 0L;
        String s = this.converter.toString(l);
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)"0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Long l = null;
        String s = this.converter.toString(l);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<LongConverter> aClass = LongConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.LONG) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

