/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasPath;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AtlasPathTest {
    @Test
    public void testOneClass() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user");
        Assert.assertEquals((Object)"/user", (Object)foo.toString());
    }

    @Test
    public void testFields() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user").appendField("name");
        Assert.assertEquals((Object)"/user/name", (Object)foo.toString());
        foo.appendField("bar");
        Assert.assertEquals((Object)"/user/name/bar", (Object)foo.toString());
    }

    @Test
    public void testCleanPathSegment() {
        Assert.assertEquals((Object)"", (Object)new AtlasPath.SegmentContext("").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo[]").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo<>").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo{}").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo[0]").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo<1234>").getName());
        Assert.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo{bar}").getName());
        Assert.assertEquals((Object)"foo[0", (Object)new AtlasPath.SegmentContext("foo[0").getName());
        Assert.assertEquals((Object)"foo1234>", (Object)new AtlasPath.SegmentContext("foo1234>").getName());
        Assert.assertEquals((Object)"foo}", (Object)new AtlasPath.SegmentContext("foo}").getName());
        Assert.assertEquals((Object)"bar", (Object)new AtlasPath.SegmentContext("foo:bar").getName());
        Assert.assertEquals((Object)"@bar", (Object)new AtlasPath.SegmentContext("foo:@bar").getName());
        Assert.assertEquals((Object)"@bar", (Object)new AtlasPath.SegmentContext("@bar").getName());
    }

    @Test
    public void testGetLastSegmentParent() {
        AtlasPath p = new AtlasPath("/orders/contact/firstName");
        Assert.assertEquals((Object)"contact", (Object)p.getLastSegmentParent().getName());
        Assert.assertTrue((boolean)new AtlasPath("orders").getLastSegmentParent().isRoot());
    }

    @Test
    public void testGetLastSegmentParentPath() {
        AtlasPath p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertEquals((Object)"/orders[]/contact", (Object)p.getLastSegmentParentPath().toString());
        Assert.assertEquals((Object)"/", (Object)new AtlasPath("orders").getLastSegmentParentPath().toString());
    }

    @Test
    public void testCollectionIndexHandling() {
        Assert.assertNull((Object)new AtlasPath.SegmentContext("").getCollectionIndex());
        Assert.assertNull((Object)new AtlasPath.SegmentContext("foo").getCollectionIndex());
        Assert.assertNull((Object)new AtlasPath.SegmentContext("foo[]").getCollectionIndex());
        Assert.assertNull((Object)new AtlasPath.SegmentContext("foo<>").getCollectionIndex());
        Assert.assertNull((Object)new AtlasPath.SegmentContext("foo{}").getCollectionIndex());
        Assert.assertEquals((Object)new Integer(0), (Object)new AtlasPath.SegmentContext("foo[0]").getCollectionIndex());
        Assert.assertEquals((Object)new Integer(1234), (Object)new AtlasPath.SegmentContext("foo<1234>").getCollectionIndex());
        Assert.assertNull((Object)new AtlasPath.SegmentContext("foo{bar}").getCollectionIndex());
        AtlasPath p = new AtlasPath("/orders[4]/contact/firstName");
        p.setCollectionIndex(1, Integer.valueOf(5));
        Assert.assertEquals((Object)"/orders[5]/contact/firstName", (Object)p.toString());
        Assert.assertEquals((Object)new Integer(5), (Object)((AtlasPath.SegmentContext)p.getSegments(true).get(1)).getCollectionIndex());
        try {
            p.setCollectionIndex(1, Integer.valueOf(-3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AtlasPath q = new AtlasPath("/orders<4>/contact/firstName");
        q.setCollectionIndex(1, Integer.valueOf(6));
        Assert.assertEquals((Object)"/orders<6>/contact/firstName", (Object)q.toString());
        Assert.assertEquals((Object)new Integer(6), (Object)((AtlasPath.SegmentContext)q.getSegments(true).get(1)).getCollectionIndex());
        AtlasPath r = new AtlasPath("/orders<>/contact/firstName");
        Assert.assertEquals((Object)"orders<>", (Object)((AtlasPath.SegmentContext)r.getSegments(true).get(1)).getExpression());
        r.setCollectionIndex(1, Integer.valueOf(6));
        Assert.assertEquals((Object)"/orders<6>/contact/firstName", (Object)r.toString());
        Assert.assertEquals((Object)new Integer(6), (Object)((AtlasPath.SegmentContext)r.getSegments(false).get(0)).getCollectionIndex());
    }

    @Test
    public void testIsIndexedCollection() {
        AtlasPath p = null;
        p = new AtlasPath("order");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("order[]");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[4]/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[0]/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<>");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<6>");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>/bar");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<3>/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<0>/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<>/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
    }

    @Test
    public void testGetLastSegment() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertEquals((Object)"firstName", (Object)p.getLastSegment().getName());
        Assert.assertEquals((Object)"firstName", (Object)p.getLastSegment().getExpression());
        Assert.assertTrue((boolean)new AtlasPath("").getLastSegment().isRoot());
        Assert.assertNotNull((Object)p.getOriginalPath());
    }

    @Test
    public void testHasCollection() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.hasCollection());
    }

    @Test
    public void testIsCollectionRoot() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/order/contact/phone<>");
        Assert.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/order<>/contact/phone");
        Assert.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/<>/order/contact/phone");
        Assert.assertFalse((boolean)p.isCollectionRoot());
    }

    @Test
    public void testIsAttributeSegment() {
        Assert.assertFalse((boolean)((AtlasPath.SegmentContext)new AtlasPath((String)null).getSegments(true).get(0)).isAttribute());
        Assert.assertFalse((boolean)((AtlasPath.SegmentContext)new AtlasPath("order").getSegments(false).get(0)).isAttribute());
        Assert.assertTrue((boolean)((AtlasPath.SegmentContext)new AtlasPath("@order").getSegments(false).get(0)).isAttribute());
    }

    @Test
    public void testGetCollectionIndex() {
        AtlasPath p = new AtlasPath("orders/order[1]");
        Assert.assertEquals((Object)new Integer(1), (Object)((AtlasPath.SegmentContext)p.getSegments(false).get(1)).getCollectionIndex());
        p = new AtlasPath("order");
        Assert.assertEquals(null, (Object)((AtlasPath.SegmentContext)p.getSegments(false).get(0)).getCollectionIndex());
        p = new AtlasPath("orders/order<2>");
        Assert.assertEquals((Object)new Integer(2), (Object)((AtlasPath.SegmentContext)p.getSegments(false).get(1)).getCollectionIndex());
    }

    @Test
    public void testGetSegments() {
        AtlasPath path = new AtlasPath("/orders");
        Assert.assertNotNull((Object)path.getSegments(true));
        List segmentContexts = path.getSegments(true);
        Assert.assertNotNull((Object)segmentContexts);
        Assert.assertEquals((long)2L, (long)segmentContexts.size());
        AtlasPath.SegmentContext sc = (AtlasPath.SegmentContext)segmentContexts.get(1);
        Assert.assertEquals((Object)"orders", (Object)sc.getName());
        Assert.assertNull((Object)sc.getCollectionIndex());
        Assert.assertEquals((Object)"orders", (Object)sc.getExpression());
        Assert.assertNotNull((Object)sc.toString());
    }

    @Test
    public void testGetParentSegmentOf() throws Exception {
        AtlasPath path = new AtlasPath("/orders/order<4>/product<6>/name");
        List segments = path.getSegments(true);
        Assert.assertEquals(null, (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(0)));
        Assert.assertEquals(segments.get(0), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(1)));
        Assert.assertEquals(segments.get(1), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(2)));
        Assert.assertEquals(segments.get(2), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(3)));
        Assert.assertEquals(segments.get(3), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(4)));
    }
}

