/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasSeparateStrategy;
import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAtlasSeparateStrategyTest {
    private AtlasSeparateStrategy separate = null;

    @Before
    public void setUp() {
        this.separate = new DefaultAtlasSeparateStrategy();
    }

    @After
    public void tearDown() {
        this.separate = null;
    }

    @Test
    public void testGetName() {
        Assert.assertNotNull((Object)this.separate);
        Assert.assertEquals((Object)"DefaultAtlasSeparateStrategy", (Object)this.separate.getName());
    }

    @Test
    public void testGetSetDelimiter() {
        Assert.assertNotNull((Object)this.separate);
        Assert.assertNotNull((Object)this.separate.getDelimiter());
        Assert.assertEquals((Object)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_DELIMITER, (Object)this.separate.getDelimiter());
        this.separate.setDelimiter(StringDelimiter.COLON);
        Assert.assertEquals((Object)StringDelimiter.COLON, (Object)this.separate.getDelimiter());
        List values = this.separate.separateValue("a:b:c:d");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((Object)new Integer(4), (Object)new Integer(values.size()));
        Assert.assertEquals((Object)"a", values.get(0));
        Assert.assertEquals((Object)"b", values.get(1));
        Assert.assertEquals((Object)"c", values.get(2));
        Assert.assertEquals((Object)"d", values.get(3));
    }

    @Test
    public void testGetSetLimit() {
        Assert.assertNotNull((Object)this.separate);
        Assert.assertNotNull((Object)this.separate.getDelimiter());
        Assert.assertEquals((Object)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_LIMIT, (Object)this.separate.getLimit());
        this.separate.setLimit(Integer.valueOf(2));
        List values = this.separate.separateValue("a b c d");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((Object)new Integer(2), (Object)new Integer(values.size()));
        Assert.assertEquals((Object)"a", values.get(0));
        Assert.assertEquals((Object)"b c d", values.get(1));
    }

    @Test
    public void testSeparateValue() {
        Assert.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue("a b c d e f");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((Object)new Integer(6), (Object)new Integer(values.size()));
        Assert.assertEquals((Object)"a", values.get(0));
        Assert.assertEquals((Object)"b", values.get(1));
        Assert.assertEquals((Object)"c", values.get(2));
        Assert.assertEquals((Object)"d", values.get(3));
        Assert.assertEquals((Object)"e", values.get(4));
        Assert.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullDelimiter() {
        Assert.assertNotNull((Object)this.separate);
        this.separate.setDelimiter(null);
        Assert.assertNull((Object)this.separate.getDelimiter());
        List values = this.separate.separateValue("a b c d e f");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((Object)new Integer(6), (Object)new Integer(values.size()));
        Assert.assertEquals((Object)"a", values.get(0));
        Assert.assertEquals((Object)"b", values.get(1));
        Assert.assertEquals((Object)"c", values.get(2));
        Assert.assertEquals((Object)"d", values.get(3));
        Assert.assertEquals((Object)"e", values.get(4));
        Assert.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullLimit() {
        Assert.assertNotNull((Object)this.separate);
        this.separate.setLimit(null);
        Assert.assertNull((Object)this.separate.getLimit());
        List values = this.separate.separateValue("a b c d e f");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((Object)new Integer(6), (Object)new Integer(values.size()));
        Assert.assertEquals((Object)"a", values.get(0));
        Assert.assertEquals((Object)"b", values.get(1));
        Assert.assertEquals((Object)"c", values.get(2));
        Assert.assertEquals((Object)"d", values.get(3));
        Assert.assertEquals((Object)"e", values.get(4));
        Assert.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullValue() {
        Assert.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue(null);
        Assert.assertNotNull((Object)values);
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testSeparateValueEmptyValue() {
        Assert.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue("");
        Assert.assertNotNull((Object)values);
        Assert.assertTrue((boolean)values.isEmpty());
    }
}

