/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.Validations;
import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasSessionTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasSessionTest.class);
    private DefaultAtlasSession session = null;

    @Before
    public void setUp() throws Exception {
        DefaultAtlasContext context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), AtlasTestData.generateAtlasMapping());
        this.session = new DefaultAtlasSession(context);
    }

    @After
    public void tearDown() {
        this.session = null;
    }

    @Test
    public void testInitializeDefaultAtlasSession() {
        Assert.assertNotNull((Object)this.session);
        Assert.assertNotNull((Object)this.session.getMapping());
        Assert.assertNotNull((Object)this.session.getAtlasContext());
        Assert.assertNotNull((Object)this.session.getAudits());
        Assert.assertNotNull((Object)this.session.getProperties());
        Assert.assertNotNull((Object)this.session.getValidations());
        Assert.assertNull((Object)this.session.getDefaultSourceDocument());
        Assert.assertNull((Object)this.session.getDefaultTargetDocument());
    }

    @Test
    public void testGetSetAtlasContext() throws Exception {
        this.session.setAtlasContext((AtlasContext)new DefaultAtlasContext(new URI("file:foo")));
        Assert.assertNotNull((Object)this.session.getAtlasContext());
        Assert.assertTrue((boolean)(this.session.getAtlasContext() instanceof DefaultAtlasContext));
    }

    @Test
    public void testGetMapping() {
        Assert.assertNotNull((Object)this.session.getMapping());
        Assert.assertNotNull((Object)this.session.getMapping().getProperties());
        Assert.assertNotNull((Object)this.session.getMapping().getProperties().getProperty());
        Assert.assertTrue((this.session.getMapping().getProperties().getProperty().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetValidations() {
        Assert.assertNotNull((Object)this.session.getValidations());
        Assert.assertNotNull((Object)this.session.getValidations().getValidation());
        Assert.assertTrue((this.session.getValidations().getValidation().size() == 0 ? 1 : 0) != 0);
        Validations validations = new Validations();
        Validation validation = new Validation();
        validation.setScope(ValidationScope.MAPPING);
        validation.setId("bar");
        validations.getValidation().add(validation);
        this.session.setValidations(validations);
        Assert.assertNotNull((Object)this.session.getValidations());
        Assert.assertNotNull((Object)this.session.getValidations().getValidation());
        Assert.assertTrue((this.session.getValidations().getValidation().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetAudits() {
        Assert.assertNotNull((Object)this.session.getAudits());
        Assert.assertNotNull((Object)this.session.getAudits().getAudit());
        Assert.assertTrue((this.session.getAudits().getAudit().size() == 0 ? 1 : 0) != 0);
        Audits audits = new Audits();
        Audit audit = new Audit();
        audit.setStatus(AuditStatus.INFO);
        audit.setMessage("hello");
        audits.getAudit().add(audit);
        this.session.setAudits(audits);
        Assert.assertNotNull((Object)this.session.getAudits());
        Assert.assertNotNull((Object)this.session.getAudits().getAudit());
        Assert.assertTrue((this.session.getAudits().getAudit().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetInput() {
        this.session.setDefaultSourceDocument((Object)new String("defaultInput"));
        Assert.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assert.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
    }

    @Test
    public void testGetSetInputDocId() {
        this.session.setDefaultSourceDocument((Object)new String("defaultInput"));
        Assert.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assert.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
        Assert.assertNotNull((Object)this.session.getSourceDocument(null));
        Assert.assertNotNull((Object)this.session.getSourceDocument(""));
        Assert.assertNotNull((Object)this.session.getSourceDocument("docId"));
        this.session.setSourceDocument("second", (Object)new String("secondInput"));
        Assert.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assert.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
        Assert.assertTrue((boolean)this.session.hasSourceDocument("second"));
        Assert.assertFalse((boolean)this.session.hasSourceDocument("third"));
        Assert.assertTrue((boolean)this.session.hasSourceDocument(null));
        Assert.assertTrue((boolean)this.session.hasSourceDocument(""));
        Assert.assertNotNull((Object)this.session.getSourceDocument("second"));
        Assert.assertTrue((boolean)(this.session.getSourceDocument("second") instanceof String));
        Assert.assertEquals((Object)"secondInput", (Object)this.session.getSourceDocument("second"));
        Assert.assertNull((Object)this.session.getSourceDocument("docId"));
        Assert.assertNotNull((Object)this.session.getSourceDocumentMap());
    }

    @Test
    public void testGetSetOutput() {
        this.session.setDefaultTargetDocument((Object)new String("defaultOutput"));
        Assert.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assert.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
    }

    @Test
    public void testGetSetOutputDocId() {
        this.session.setDefaultTargetDocument((Object)new String("defaultOutput"));
        Assert.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assert.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
        Assert.assertNotNull((Object)this.session.getTargetDocument(null));
        Assert.assertNotNull((Object)this.session.getTargetDocument(""));
        Assert.assertNotNull((Object)this.session.getTargetDocument("second"));
        this.session.setTargetDocument("second", (Object)new String("secondOutput"));
        Assert.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assert.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assert.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
        Assert.assertTrue((boolean)this.session.hasTargetDocument("second"));
        Assert.assertFalse((boolean)this.session.hasTargetDocument("third"));
        Assert.assertNotNull((Object)this.session.getTargetDocument("second"));
        Assert.assertTrue((boolean)(this.session.getTargetDocument("second") instanceof String));
        Assert.assertEquals((Object)"secondOutput", (Object)this.session.getTargetDocument("second"));
        Assert.assertNull((Object)this.session.getTargetDocument("docId"));
        Assert.assertNotNull((Object)this.session.getTargetDocumentMap());
    }

    @Test
    public void testGetProperties() {
        Assert.assertNotNull((Object)this.session);
        Assert.assertNotNull((Object)this.session.getProperties());
        Assert.assertTrue((this.session.getProperties().size() == 0 ? 1 : 0) != 0);
        this.session.getProperties().put("foo", "bar");
        Assert.assertTrue((this.session.getProperties().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"bar", this.session.getProperties().get("foo"));
    }

    @Test
    public void testAuditErrors() {
        Assert.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasErrors());
        Assert.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasWarns());
        Audit error = new Audit();
        error.setStatus(AuditStatus.ERROR);
        this.session.getAudits().getAudit().add(error);
        Assert.assertTrue((this.session.errorCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.session.hasErrors());
        Assert.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasWarns());
    }

    @Test
    public void testAuditWarns() {
        Assert.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasErrors());
        Assert.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasWarns());
        Audit warn = new Audit();
        warn.setStatus(AuditStatus.WARN);
        this.session.getAudits().getAudit().add(warn);
        Assert.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.session.hasErrors());
        Assert.assertTrue((this.session.warnCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.session.hasWarns());
    }

    @Test
    public void testSetTargetDocument() {
        this.session.setTargetDocument("target", (Object)"defaultOutput");
        this.session.setTargetDocument(null, (Object)"defaultOutput");
        this.session.setTargetDocument("", (Object)"defaultOutput");
        this.session.hasTargetDocument(null);
        this.session.hasTargetDocument("");
    }

    @Test
    public void testSetSourceDocument() {
        this.session.setSourceDocument("source", (Object)"defaultInput");
        this.session.setSourceDocument(null, (Object)"defaultInput");
        this.session.setSourceDocument("", (Object)"defaultInput");
    }

    @Test
    public void testGetFieldReader() {
        AtlasFieldReader reader = new AtlasFieldReader(){

            public Field read(AtlasInternalSession session) throws AtlasException {
                LOG.debug("read method");
                return session.head().getSourceField();
            }
        };
        this.session.setFieldReader("ATLAS_DEFAULT_SOURCE_DOC", reader);
        Assert.assertNotNull((Object)this.session.getFieldReader(null));
        Assert.assertNotNull((Object)this.session.getFieldReader(""));
        Assert.assertNotNull((Object)this.session.getFieldReader("ATLAS_DEFAULT_SOURCE_DOC"));
        Assert.assertNotNull((Object)this.session.getFieldReader("", AtlasFieldReader.class));
    }

    @Test
    public void testSetFieldReader() {
        AtlasFieldReader reader = new AtlasFieldReader(){

            public Field read(AtlasInternalSession session) throws AtlasException {
                LOG.debug("read method");
                return session.head().getSourceField();
            }
        };
        this.session.setFieldReader(null, reader);
        this.session.setFieldReader("", reader);
    }

    @Test
    public void testRemoveFieldReader() {
        this.session.removeFieldReader(null);
        this.session.removeFieldReader("");
        this.session.removeFieldReader("ATLAS_DEFAULT_SOURCE_DOC");
    }

    @Test
    public void testGetFieldWriter() {
        AtlasFieldWriter writer = new AtlasFieldWriter(){

            public void write(AtlasInternalSession session) throws AtlasException {
                LOG.debug("write method");
            }
        };
        this.session.setFieldWriter("ATLAS_DEFAULT_TARGET_DOC", writer);
        Assert.assertNotNull((Object)this.session.getFieldWriter(null));
        Assert.assertNotNull((Object)this.session.getFieldWriter(""));
        Assert.assertNotNull((Object)this.session.getFieldWriter("ATLAS_DEFAULT_TARGET_DOC"));
        Assert.assertNotNull((Object)this.session.getFieldWriter("", AtlasFieldWriter.class));
    }

    @Test
    public void testSetFieldWriter() {
        AtlasFieldWriter writer = new AtlasFieldWriter(){

            public void write(AtlasInternalSession session) throws AtlasException {
                LOG.debug("write method");
            }
        };
        this.session.setFieldWriter(null, writer);
        this.session.setFieldWriter("", writer);
    }

    @Test
    public void testRemoveFieldWriter() {
        this.session.removeFieldWriter(null);
        this.session.removeFieldWriter("");
        this.session.removeFieldWriter("ATLAS_DEFAULT_TARGET_DOC");
    }

    @Test
    public void testHead() {
        AtlasInternalSession.Head head = this.session.head();
        Assert.assertNotNull((Object)head);
        Assert.assertNull((Object)head.getLookupTable());
        Assert.assertNull((Object)head.getMapping());
        Assert.assertNull((Object)head.getSourceField());
        Assert.assertNull((Object)head.getTargetField());
        head.setLookupTable(null);
        head.setMapping(null);
        head.setSourceField(null);
        head.setTargetField(null);
        Assert.assertNotNull((Object)head.unset());
    }
}

