/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasMappingUtil;
import io.atlasmap.core.DefaultAtlasValidationService;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.validators.BaseValidatorTest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAtlasValidationServiceTest
extends BaseValidatorTest {
    private DefaultAtlasValidationService validationService = null;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.validationService = new DefaultAtlasValidationService();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.validationService = null;
    }

    @Test
    public void testValidateAtlasMappingFileHappyPath() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assert.assertNotNull((Object)mapping);
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileHappyPath2() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assert.assertNotNull((Object)mapping);
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileInvalidName() {
        AtlasMapping mapping = new AtlasMapping();
        mapping.setName("thisis in_valid.name");
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileLookupTablesDuplicateNames() {
        AtlasMapping mapping = this.getAtlasMappingWithLookupTables("duplicate_name", "duplicate_name");
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileLookupFieldMappingRefNonExistentNames() {
        AtlasMapping mapping = this.getAtlasMappingWithLookupTables("table1", "table2");
        Mapping lookupFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.LOOKUP);
        lookupFieldMapping.setLookupTableName("table3");
        Field inputField = this.createInputJavaField("inputName");
        Field outputField = this.createInputJavaField("outputName");
        lookupFieldMapping.getInputField().add(inputField);
        lookupFieldMapping.getOutputField().add(outputField);
        mapping.getMappings().getMapping().add(lookupFieldMapping);
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileLookupFieldMappingUnusedLookupTable() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        LookupTables lookupTables = new LookupTables();
        mapping.setLookupTables(lookupTables);
        LookupTable lookupTable = new LookupTable();
        lookupTable.setName("table1");
        lookupTable.setDescription("desc_table1");
        LookupTable lookupTable2 = new LookupTable();
        lookupTable2.setName("table2");
        lookupTable2.setDescription("desc_table2");
        lookupTables.getLookupTable().add(lookupTable);
        lookupTables.getLookupTable().add(lookupTable2);
        Mapping lookupFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.LOOKUP);
        lookupFieldMapping.setLookupTableName("table1");
        Field inputField = this.createInputJavaField("inputName");
        Field outputField = this.createInputJavaField("outputName");
        lookupFieldMapping.getInputField().add(inputField);
        lookupFieldMapping.getOutputField().add(outputField);
        mapping.getMappings().getMapping().add(lookupFieldMapping);
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileNoLookupFieldMappingsWithTablesDefined() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        LookupTables lookupTables = new LookupTables();
        mapping.setLookupTables(lookupTables);
        LookupTable lookupTable = new LookupTable();
        lookupTable.setName("table1");
        lookupTable.setDescription("desc_table1");
        lookupTables.getLookupTable().add(lookupTable);
        this.validations.addAll(this.validationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testAtlasMappingUtil() throws Exception {
        Files.createDirectories(Paths.get("target/mappings", new String[0]), new FileAttribute[0]);
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assert.assertNotNull((Object)mapping);
        AtlasMappingUtil atlasMappingUtil = new AtlasMappingUtil();
        String fileName = "target/mappings/HappyPathMapping.json";
        atlasMappingUtil.marshallMapping(mapping, "target/mappings/HappyPathMapping.json");
        Assert.assertTrue((boolean)Files.exists(Paths.get("target/mappings/HappyPathMapping.json", new String[0]), new LinkOption[0]));
        AtlasMapping atlasMapping = atlasMappingUtil.loadMapping("target/mappings/HappyPathMapping.json");
        Assert.assertNotNull((Object)atlasMapping);
    }
}

