/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.DateTimeHelper;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateConverter
implements AtlasConverter<java.util.Date> {
    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(java.util.Date date) {
        return BigDecimal.valueOf(date.getTime());
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(java.util.Date date) {
        return BigInteger.valueOf(date.getTime());
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(java.util.Date value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = value.getTime();
        if (longValue < -128L || longValue > 127L) {
            throw new AtlasConversionException(String.format("LocalDateTime %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value));
        }
        return longValue.byteValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        return calendar;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DOUBLE)
    public Double toDouble(java.util.Date value) {
        return value != null ? Double.valueOf(value.getTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.FLOAT)
    public Float toFloat(java.util.Date value) {
        return value != null ? Float.valueOf(value.getTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer toInteger(java.util.Date value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = value.getTime();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new AtlasConversionException(String.format("Date %s is greater than Integer.MAX_VALUE or less than Integer.MIN_VALUE", value));
        }
        return longValue.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToGregorianCalendar(date, sourceFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public LocalDate toLocalDate(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToLocalDate(date, targetFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToLocalDateTime(date, targetFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public LocalTime toLocalTime(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToLocalTime(date, targetFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.LONG)
    public Long toLong(java.util.Date date) {
        return date.toInstant().toEpochMilli();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.NUMBER)
    public Number toNumber(java.util.Date date) {
        return date.toInstant().toEpochMilli();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short toShort(java.util.Date value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = value.getTime();
        if (longValue > 32767L || longValue < -32768L) {
            throw new AtlasConversionException(String.format("Date %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return longValue.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public Date toSqlDate(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToSqlDate(date, sourceFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public Time toSqlTime(java.util.Date date, String sourceFormat, String targetFormat) {
        return DateTimeHelper.convertDateToTime(date, targetFormat);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public String toString(java.util.Date date) {
        return date.toInstant().toString();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public CharBuffer toCharBuffer(java.util.Date value) {
        return value != null ? CharBuffer.wrap(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public CharSequence toCharSequence(java.util.Date value) {
        return value != null ? this.toString(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public StringBuffer toStringBuffer(java.util.Date value) {
        return value != null ? new StringBuffer(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public StringBuilder toStringBuilder(java.util.Date value) {
        return value != null ? new StringBuilder(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public Timestamp toSqlTimestamp(java.util.Date date) {
        return Timestamp.from(date.toInstant());
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(java.util.Date date) {
        return DateTimeHelper.toZonedDateTime(date, null);
    }
}

