/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringSimpleFieldActions;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.LowercaseChar;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import io.atlasmap.v2.UppercaseChar;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSimpleFieldActionsTest {
    @Test
    public void testCapitalize() {
        Assertions.assertNull((Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)""));
        Assertions.assertEquals((Object)" foo ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)" foo "));
        Assertions.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"   Foo"));
        Assertions.assertEquals((Object)"FOo   ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"fOo   "));
        Assertions.assertEquals((Object)"    foO   ", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"    foO   "));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"\t\n   FOO"));
        Assertions.assertEquals((Object)"\t\n   FOO\f\r", (Object)StringSimpleFieldActions.capitalize((Capitalize)new Capitalize(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testFileExtension() {
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, null));
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, (String)""));
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, (String)"foo"));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, (String)"."));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo."));
        Assertions.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo.bar"));
        Assertions.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, (String)"foo.foo.bar"));
    }

    @Test
    public void testLowerCase() {
        Assertions.assertNull((Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"Foo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"fOo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"foO"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"FOO"));
        Assertions.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.lowercase((Lowercase)new Lowercase(), (String)"FOO BAR"));
    }

    @Test
    public void testLowerCaseChar() {
        Assertions.assertNull((Object)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), null));
        Assertions.assertEquals((char)'\u0000', (char)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('\u0000')).charValue());
        Assertions.assertEquals((char)'f', (char)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('f')).charValue());
        Assertions.assertEquals((char)'f', (char)StringSimpleFieldActions.lowercaseChar((LowercaseChar)new LowercaseChar(), (Character)Character.valueOf('F')).charValue());
    }

    @Test
    public void testNormalize() {
        Assertions.assertNull((Object)StringSimpleFieldActions.normalize(null, null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.normalize(null, (String)""));
        Assertions.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.normalize(null, (String)" foo bar "));
        Assertions.assertEquals((Object)"Foo Bar", (Object)StringSimpleFieldActions.normalize(null, (String)"   Foo Bar   "));
        Assertions.assertEquals((Object)"fOo bar", (Object)StringSimpleFieldActions.normalize(null, (String)"fOo   bar"));
        Assertions.assertEquals((Object)"foO bar", (Object)StringSimpleFieldActions.normalize(null, (String)"    foO   bar   "));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, (String)"\t\n   FOO \f\t BAR "));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, (String)"\t\n   FOO \f\r BAR\f\r"));
    }

    @Test
    public void testRemoveFileExtension() {
        Assertions.assertNull((Object)StringSimpleFieldActions.removeFileExtension(null, null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo"));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"."));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo."));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo.bar"));
        Assertions.assertEquals((Object)"foo.foo", (Object)StringSimpleFieldActions.removeFileExtension(null, (String)"foo.foo.bar"));
    }

    @Test
    public void testSeparateByDash() {
        Assertions.assertNull((Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)""));
        Assertions.assertEquals((Object)"-", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"-"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo+bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo=bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"foo:bar"));
        Assertions.assertEquals((Object)"f-o-o-b-a-r", (Object)StringSimpleFieldActions.separateByDash((SeparateByDash)new SeparateByDash(), (String)"f:o:o:b:a:r"));
    }

    @Test
    public void testSeparateByUnderscore() {
        Assertions.assertNull((Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)""));
        Assertions.assertEquals((Object)"_", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"-"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo+bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo=bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"foo:bar"));
        Assertions.assertEquals((Object)"f_o_o_b_a_r", (Object)StringSimpleFieldActions.separateByUnderscore((SeparateByUnderscore)new SeparateByUnderscore(), (String)"f:o:o:b:a:r"));
    }

    @Test
    public void testSeparatorRegex() {
        Pattern pattern = Pattern.compile("[\\s+\\:\\_\\+\\=\\-]+");
        Assertions.assertFalse((boolean)pattern.matcher("foo").find());
        Assertions.assertFalse((boolean)pattern.matcher("").find());
        Assertions.assertTrue((boolean)pattern.matcher("f o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f+o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f=o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f_o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f:o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f:o:o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f  o").find());
    }

    @Test
    public void testTrim() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trim((Trim)new Trim(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)" foo "));
        Assertions.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"   Foo"));
        Assertions.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"fOo   "));
        Assertions.assertEquals((Object)"foO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"    foO   "));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"\t\n   FOO"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim((Trim)new Trim(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimLeft() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)""));
        Assertions.assertEquals((Object)"foo ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)" foo "));
        Assertions.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"   Foo"));
        Assertions.assertEquals((Object)"fOo   ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"fOo   "));
        Assertions.assertEquals((Object)"foO   ", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"    foO   "));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"\t\n   FOO"));
        Assertions.assertEquals((Object)"FOO\f\r", (Object)StringSimpleFieldActions.trimLeft((TrimLeft)new TrimLeft(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimRight() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)""));
        Assertions.assertEquals((Object)" foo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)" foo "));
        Assertions.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"   Foo"));
        Assertions.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"fOo   "));
        Assertions.assertEquals((Object)"    foO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"    foO   "));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"\t\n   FOO"));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight((TrimRight)new TrimRight(), (String)"\t\n   FOO\f\r"));
    }

    @Test
    public void testUpperCase() {
        Assertions.assertNull((Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)""));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"Foo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"fOo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foO"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"FOO"));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.uppercase((Uppercase)new Uppercase(), (String)"foo bar"));
    }

    @Test
    public void testUpperCaseChar() {
        Assertions.assertNull((Object)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), null));
        Assertions.assertEquals((char)'\u0000', (char)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('\u0000')).charValue());
        Assertions.assertEquals((char)'F', (char)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('f')).charValue());
        Assertions.assertEquals((char)'F', (char)StringSimpleFieldActions.uppercaseChar((UppercaseChar)new UppercaseChar(), (Character)Character.valueOf('F')).charValue());
    }
}

