/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.ByteConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteConverterTest {
    private static final byte DEFAULT_VALUE = 100;
    private ByteConverter byteConverter = new ByteConverter();

    @Test
    public void convertToBoolean() {
        Assertions.assertTrue((boolean)this.byteConverter.toBoolean(new Byte(1)));
        Assertions.assertFalse((boolean)this.byteConverter.toBoolean(new Byte(0)));
        Assertions.assertTrue((boolean)this.byteConverter.toBoolean(Byte.valueOf((byte)127)));
    }

    @Test
    public void convertToBooleanNull() {
        Assertions.assertNull((Object)this.byteConverter.toBoolean(null));
    }

    @Test
    public void convertToByte() {
        this.byteConverter.toByte(Byte.valueOf((byte)127));
    }

    @Test
    public void convertToByteNull() {
        Assertions.assertNull((Object)this.byteConverter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        byte value = 0;
        Assertions.assertEquals((char)'\u0000', (char)this.byteConverter.toCharacter(new Byte(value)).charValue());
        value = 99;
        Assertions.assertEquals((char)'c', (char)this.byteConverter.toCharacter(new Byte(value)).charValue());
    }

    @Test
    public void convertToCharacterNull() {
        Assertions.assertNull((Object)this.byteConverter.toCharacter(null));
    }

    @Test
    public void convertToDouble() {
        Assertions.assertEquals((double)100.0, (double)this.byteConverter.toDouble(Byte.valueOf((byte)100)), (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Assertions.assertNull((Object)this.byteConverter.toDouble(null));
    }

    @Test
    public void convertToFloat() {
        Assertions.assertEquals((float)100.0f, (float)this.byteConverter.toFloat(Byte.valueOf((byte)100)).floatValue(), (float)0.0f);
    }

    @Test
    public void convertToFloatNull() {
        Assertions.assertNull((Object)this.byteConverter.toFloat(null));
    }

    @Test
    public void convertToInteger() {
        Assertions.assertEquals((int)100, (int)this.byteConverter.toInteger(Byte.valueOf((byte)100)));
    }

    @Test
    public void convertToIntegerNull() {
        Assertions.assertNull((Object)this.byteConverter.toInteger(null));
    }

    @Test
    public void convertToLong() {
        Assertions.assertEquals((long)100L, (long)this.byteConverter.toLong(Byte.valueOf((byte)100)));
    }

    @Test
    public void convertToLongNull() {
        Assertions.assertNull((Object)this.byteConverter.toLong(null));
    }

    @Test
    public void convertToShort() {
        Assertions.assertEquals((int)100, (int)this.byteConverter.toShort(Byte.valueOf((byte)100)).shortValue());
    }

    @Test
    public void convertToIShortNull() {
        Assertions.assertNull((Object)this.byteConverter.toShort(null));
    }

    @Test
    public void convertToString() throws Exception {
        Assertions.assertEquals((Object)this.byteConverter.toString(Byte.valueOf(Byte.parseByte("1"))), (Object)"1");
    }

    @Test
    public void convertToStringNull() {
        Assertions.assertNull((Object)this.byteConverter.toString(null));
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<ByteConverter> aClass = ByteConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assertions.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.BYTE) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

