/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.CharSequenceConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.time.Instant;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharSequenceConverterTest {
    private CharSequenceConverter converter = new CharSequenceConverter();

    @Test
    public void convertToBoolean() {
        String f = "0";
        String t = "1";
        String capitalT = "T";
        String capitalF = "F";
        String smallT = "t";
        String smallF = "f";
        String strTrue = "true";
        String strFalse = "false";
        Boolean b = this.converter.toBoolean((CharSequence)t, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean((CharSequence)f, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
        b = this.converter.toBoolean((CharSequence)capitalT, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean((CharSequence)capitalF, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
        b = this.converter.toBoolean((CharSequence)smallT, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean((CharSequence)smallF, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
        b = this.converter.toBoolean((CharSequence)strTrue, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean((CharSequence)strFalse, null, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean b = this.converter.toBoolean(null, null, null);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanFallback() {
        String s = "";
        Boolean b = this.converter.toBoolean((CharSequence)s, null, null);
        Assertions.assertFalse((boolean)b);
        b = this.converter.toBoolean((CharSequence)"junk", null, null);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        String s = "0";
        Byte value = 0;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte((CharSequence)s));
        s = "+127";
        value = 127;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte((CharSequence)s));
        s = "-128";
        value = -128;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte((CharSequence)s));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToByteMAX() throws Exception {
        String s = String.valueOf(127);
        Byte l = this.converter.toByte((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)127.0, (double)l.byteValue(), (double)0.0);
    }

    @Test
    public void convertToByteMIN() throws Exception {
        String s = String.valueOf(-128);
        Byte l = this.converter.toByte((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)-128.0, (double)l.byteValue(), (double)0.0);
    }

    @Test
    public void convertToByteGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "128";
            this.converter.toByte((CharSequence)s);
        });
    }

    @Test
    public void convertToByteLessThanMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "-129";
            this.converter.toByte((CharSequence)s);
        });
    }

    @Test
    public void convertToCharacter() throws Exception {
        String s = "0";
        Character c = this.converter.toCharacter((CharSequence)s);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)48, (int)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Character c = this.converter.toCharacter(null);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterEmptyString() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "";
            this.converter.toCharacter((CharSequence)s);
        });
    }

    @Test
    public void convertToCharacterStringSpace() throws Exception {
        String s = " ";
        Character c = this.converter.toCharacter((CharSequence)s);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)32, (int)c.charValue());
    }

    @Test
    public void convertToDate() {
        Date date = this.converter.toDate((CharSequence)Instant.now().toString(), null, null);
        Assertions.assertNotNull((Object)date);
        date = this.converter.toDate((CharSequence)"2014-02-20T20:04:05.867Z", null, null);
        Assertions.assertNotNull((Object)date);
    }

    @Test
    public void convertToDouble() throws Exception {
        String s = "0.0";
        Double d = this.converter.toDouble((CharSequence)s);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() throws Exception {
        Double d = this.converter.toDouble(null);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() throws Exception {
        String s = String.valueOf(Double.MAX_VALUE);
        Double d = this.converter.toDouble((CharSequence)s);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "1.7976931348623157E400";
            this.converter.toDouble((CharSequence)s);
        });
    }

    @Test
    public void convertToDoubleLessThanMIN() throws Exception {
        String s = "-4.9E-325";
        Double d = this.converter.toDouble((CharSequence)s);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleUnparseable() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "1.2efff";
            this.converter.toDouble((CharSequence)s);
        });
    }

    @Test
    public void convertToFloat() throws Exception {
        String s = "0";
        Float f = this.converter.toFloat((CharSequence)s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
        s = "1";
        f = this.converter.toFloat((CharSequence)s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() throws Exception {
        String s = "3.4028235E38";
        Float f = this.converter.toFloat((CharSequence)s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)3.4028234663852886E38, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatMIN() throws Exception {
        String s = "1.401298464324817E-45";
        Float f = this.converter.toFloat((CharSequence)s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)1.4E-45f, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatUnparsable() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "QWERTY";
            this.converter.toFloat((CharSequence)s);
        });
    }

    @Test
    public void convertToFloatGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "3.4028235E39";
            this.converter.toFloat((CharSequence)s);
        });
    }

    @Test
    public void convertToFloatLessThanMIN() throws Exception {
        String s = "1.4E-49";
        Float f = this.converter.toFloat((CharSequence)s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() throws Exception {
        String s = "0";
        Integer i = this.converter.toInteger((CharSequence)s);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
        s = "3.5";
        i = this.converter.toInteger((CharSequence)s);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)3.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Integer i = this.converter.toInteger(null);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToIntegerLessThanMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "-21474836495554545";
            this.converter.toInteger((CharSequence)s);
        });
    }

    @Test
    public void convertToIntegerGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "214748364755545422145221";
            this.converter.toInteger((CharSequence)s);
        });
    }

    @Test
    public void convertToIntegerUnparseable() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "2147483648qwerty";
            this.converter.toInteger((CharSequence)s);
        });
    }

    @Test
    public void convertToLong() throws Exception {
        String s = "1";
        Long l = this.converter.toLong((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)1.0, (double)l.longValue(), (double)0.0);
        s = "3.5";
        l = this.converter.toLong((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)3.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() throws Exception {
        Long l = this.converter.toLong(null);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToLongMAX() throws Exception {
        String s = String.valueOf(Long.MAX_VALUE);
        Long l = this.converter.toLong((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongMIN() throws Exception {
        String s = String.valueOf(Long.MIN_VALUE);
        Long l = this.converter.toLong((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)-9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "9223372036854775808";
            this.converter.toLong((CharSequence)s);
        });
    }

    @Test
    public void convertToLongLessThanMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "-9223372036854775809";
            this.converter.toLong((CharSequence)s);
        });
    }

    @Test
    public void convertToLongUnparsable() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "QWERTY";
            this.converter.toLong((CharSequence)s);
        });
    }

    @Test
    public void convertToShort() throws Exception {
        String aString = "0";
        Short s = this.converter.toShort((CharSequence)aString);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Short s = this.converter.toShort(null);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToShortMAX() throws Exception {
        String s = String.valueOf(Short.MAX_VALUE);
        Short l = this.converter.toShort((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)32767.0, (double)l.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortMIN() throws Exception {
        String s = String.valueOf(Short.MIN_VALUE);
        Short l = this.converter.toShort((CharSequence)s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)-32768.0, (double)l.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "9223372036854775808";
            this.converter.toShort((CharSequence)s);
        });
    }

    @Test
    public void convertToShortLessThanMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "-9223372036854775809";
            this.converter.toShort((CharSequence)s);
        });
    }

    @Test
    public void convertToShortUnparsable() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            String s = "QWERTY";
            this.converter.toShort((CharSequence)s);
        });
    }

    @Test
    public void convertToCharSequence() {
        String zero = "0";
        CharSequence converted = this.converter.toCharSequence((CharSequence)zero, null, null);
        Assertions.assertNotNull((Object)converted);
        Assertions.assertNotSame((Object)converted, (Object)zero);
        Assertions.assertTrue((boolean)"0".equals(converted));
    }

    @Test
    public void convertToCharSequenceNull() {
        CharSequence s = this.converter.toCharSequence(null, null, null);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToCharBuffer() {
        CharBuffer cb = this.converter.toCharBuffer((CharSequence)"test", null, null);
        Assertions.assertNotNull((Object)cb);
    }

    @Test
    public void convertToString() {
        String s = this.converter.toString((CharSequence)"test", null, null);
        Assertions.assertNotNull((Object)s);
    }

    @Test
    public void convertToStringBuffer() {
        StringBuffer sb = this.converter.toStringBuffer((CharSequence)"test", null, null);
        Assertions.assertNotNull((Object)sb);
    }

    @Test
    public void convertToStringBuilder() {
        StringBuilder sb = this.converter.toStringBuilder((CharSequence)"test", null, null);
        Assertions.assertNotNull((Object)sb);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<CharSequenceConverter> aClass = CharSequenceConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assertions.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.STRING) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testConvertToNumber() throws AtlasConversionException {
        CharSequenceConverter converter = new CharSequenceConverter();
        Assertions.assertNull((Object)converter.toNumber(null));
        Assertions.assertNull((Object)converter.toNumber((CharSequence)" "));
        Assertions.assertNotNull((Object)converter.toNumber((CharSequence)"1"));
        Assertions.assertNotNull((Object)converter.toNumber((CharSequence)"1.99"));
    }

    @Test
    public void testConvertToNumberAtlasConversionException() throws AtlasConversionException {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            CharSequenceConverter converter = new CharSequenceConverter();
            Assertions.assertNull((Object)converter.toNumber((CharSequence)"abc"));
        });
    }
}

