/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.config;

import io.axual.client.config.DeliveryStrategy;
import io.axual.client.proxy.generic.registry.ProxyChain;
import io.axual.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Deserializer;

@InterfaceStability.Evolving
public class BaseConsumerConfig<K, V> {
    public static final ProxyChain DEFAULT_PROXY_CHAIN = ProxyChain.newBuilder().append("SWITCHING").append("RESOLVING").append("LINEAGE").append("HEADER").build();
    private static final int DEFAULT_POLL_SIZE = 100;
    private DeliveryStrategy deliveryStrategy;
    private String stream;
    private Object keyDeserializer;
    private Object valueDeserializer;
    private final int maximumPollSize;
    private final ProxyChain proxyChain;

    BaseConsumerConfig(Builder<K, V, ?> builder) {
        this.deliveryStrategy = ((Builder)builder).deliveryStrategy;
        this.stream = ((Builder)builder).stream;
        this.keyDeserializer = ((Builder)builder).keyDeserializer;
        this.valueDeserializer = ((Builder)builder).valueDeserializer;
        this.maximumPollSize = ((Builder)builder).maximumPollSize;
        this.proxyChain = ((Builder)builder).proxyChain;
    }

    public String getStream() {
        return this.stream;
    }

    public DeliveryStrategy getDeliveryStrategy() {
        return this.deliveryStrategy;
    }

    public Object getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public Object getValueDeserializer() {
        return this.valueDeserializer;
    }

    public Integer getMaximumPollSize() {
        return this.maximumPollSize;
    }

    public ProxyChain getProxyChain() {
        return this.proxyChain;
    }

    protected static class Builder<K, V, T extends Builder<K, V, T>> {
        private DeliveryStrategy deliveryStrategy = DeliveryStrategy.AT_LEAST_ONCE;
        private String stream;
        private Object keyDeserializer;
        private Object valueDeserializer;
        private int maximumPollSize = 100;
        private ProxyChain proxyChain = DEFAULT_PROXY_CHAIN;

        protected Builder() {
        }

        public T setDeliveryStrategy(DeliveryStrategy deliveryStrategy) {
            this.deliveryStrategy = deliveryStrategy;
            return (T)this;
        }

        public T setStream(String stream) {
            this.stream = stream;
            return (T)this;
        }

        public T setKeyDeserializer(String keyDeserializerClassName) {
            this.keyDeserializer = keyDeserializerClassName;
            return (T)this;
        }

        public T setKeyDeserializer(Deserializer<K> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
            return (T)this;
        }

        public T setValueDeserializer(String valueDeserializerClassName) {
            this.valueDeserializer = valueDeserializerClassName;
            return (T)this;
        }

        public T setValueDeserializer(Deserializer<V> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
            return (T)this;
        }

        public T setMaximumPollSize(int maximumPollSize) {
            this.maximumPollSize = maximumPollSize;
            return (T)this;
        }

        public T setProxyChain(ProxyChain proxyChain) {
            this.proxyChain = proxyChain;
            return (T)this;
        }

        public void validate() {
            if (this.deliveryStrategy == null) {
                throw new IllegalStateException("Error building configuration: DeliveryStrategy is missing");
            }
            if (this.stream == null || this.stream.length() == 0) {
                throw new IllegalStateException("Error building configuration: stream is missing");
            }
            if (this.keyDeserializer == null || this.keyDeserializer instanceof String && ((String)this.keyDeserializer).isEmpty()) {
                throw new IllegalStateException("Error building configuration: keyDeserializer is missing");
            }
            if (this.valueDeserializer == null || this.valueDeserializer instanceof String && ((String)this.valueDeserializer).isEmpty()) {
                throw new IllegalStateException("Error building configuration: valueDeserializer is missing");
            }
            if (this.maximumPollSize < 1 || this.maximumPollSize > 500) {
                throw new IllegalStateException("Consumer poll size must be between 0 and 500, current value is " + this.maximumPollSize);
            }
        }

        public BaseConsumerConfig<K, V> build() {
            this.validate();
            return new BaseConsumerConfig(this);
        }
    }
}

