/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.config;

import io.axual.client.config.DeliveryStrategy;
import io.axual.client.config.OrderingStrategy;
import io.axual.client.proxy.generic.registry.ProxyChain;
import io.axual.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Serializer;

@InterfaceStability.Evolving
public class BaseProducerConfig<K, V> {
    public static final ProxyChain DEFAULT_PROXY_CHAIN = ProxyChain.newBuilder().append("SWITCHING").append("RESOLVING").append("LINEAGE").append("HEADER").build();
    private final DeliveryStrategy deliveryStrategy;
    private final OrderingStrategy orderingStrategy;
    private final boolean blocking;
    private final int messageBufferSize;
    private final int messageBufferWaitTimeout;
    private final Object keySerializer;
    private final Object valueSerializer;
    private final int batchSize;
    private final long lingerMs;
    private final ProxyChain proxyChain;

    protected BaseProducerConfig(Builder<K, V, ?> builder) {
        this.deliveryStrategy = builder.deliveryStrategy;
        this.orderingStrategy = builder.orderingStrategy;
        this.blocking = builder.blocking;
        this.messageBufferSize = builder.messageBufferSize;
        this.messageBufferWaitTimeout = builder.messageBufferWaitTimeout;
        this.keySerializer = builder.keySerializer;
        this.valueSerializer = builder.valueSerializer;
        this.batchSize = builder.batchSize;
        this.lingerMs = builder.lingerMs;
        this.proxyChain = builder.proxyChain;
    }

    public DeliveryStrategy getDeliveryStrategy() {
        return this.deliveryStrategy;
    }

    public OrderingStrategy getOrderingStrategy() {
        return this.orderingStrategy;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getMessageBufferSize() {
        return this.messageBufferSize;
    }

    public int getMessageBufferWaitTimeout() {
        return this.messageBufferWaitTimeout;
    }

    public Object getKeySerializer() {
        return this.keySerializer;
    }

    public Object getValueSerializer() {
        return this.valueSerializer;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public long getLingerMs() {
        return this.lingerMs;
    }

    public ProxyChain getProxyChain() {
        return this.proxyChain;
    }

    public static class Builder<K, V, T extends Builder<K, V, T>> {
        protected DeliveryStrategy deliveryStrategy;
        protected OrderingStrategy orderingStrategy = OrderingStrategy.LOSING_ORDER;
        protected Boolean blocking;
        protected Integer messageBufferSize;
        protected int messageBufferWaitTimeout = 0;
        protected Object keySerializer;
        protected Object valueSerializer;
        protected int batchSize = 262144;
        protected long lingerMs = 0L;
        protected ProxyChain proxyChain = DEFAULT_PROXY_CHAIN;

        public T setDeliveryStrategy(DeliveryStrategy deliveryStrategy) {
            this.deliveryStrategy = deliveryStrategy;
            return (T)this;
        }

        public T setOrderingStrategy(OrderingStrategy orderingStrategy) {
            this.orderingStrategy = orderingStrategy;
            return (T)this;
        }

        public T setBlocking(boolean blocking) {
            this.blocking = blocking;
            return (T)this;
        }

        public T setMessageBufferSize(int messageBufferSize) {
            this.messageBufferSize = messageBufferSize;
            return (T)this;
        }

        public T setMessageBufferWaitTimeout(int messageBufferWaitTimeout) {
            this.messageBufferWaitTimeout = messageBufferWaitTimeout;
            return (T)this;
        }

        public T setKeySerializer(String keySerializerClassName) {
            this.keySerializer = keySerializerClassName;
            return (T)this;
        }

        public T setKeySerializer(Serializer<K> keySerializer) {
            this.keySerializer = keySerializer;
            return (T)this;
        }

        public T setValueSerializer(String valueSerializerClassName) {
            this.valueSerializer = valueSerializerClassName;
            return (T)this;
        }

        public T setValueSerializer(Serializer<V> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return (T)this;
        }

        public T setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return (T)this;
        }

        public T setLingerMs(long lingerMs) {
            this.lingerMs = lingerMs;
            return (T)this;
        }

        public T setProxyChain(ProxyChain proxyChain) {
            this.proxyChain = proxyChain;
            return (T)this;
        }

        public void validate() {
            if (this.deliveryStrategy == null) {
                throw new IllegalStateException("Error building configuration: DeliveryStrategy is missing");
            }
            if (this.blocking == null) {
                this.blocking = true;
            }
            if (this.messageBufferSize == null) {
                this.messageBufferSize = 1000;
            }
            if (this.keySerializer == null || this.keySerializer instanceof String && ((String)this.keySerializer).isEmpty()) {
                throw new IllegalStateException("Error building producer configuration: keySerializer is missing");
            }
            if (this.valueSerializer == null || this.valueSerializer instanceof String && ((String)this.valueSerializer).isEmpty()) {
                throw new IllegalStateException("Error building producer configuration: valueSerializer is missing");
            }
        }

        public BaseProducerConfig<K, V> build() {
            this.validate();
            return new BaseProducerConfig(this);
        }
    }
}

