/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.config;

import io.axual.client.config.BaseAvroConsumerConfig;
import io.axual.common.annotation.InterfaceStability;
import io.axual.common.exception.ClientException;
import io.axual.serde.avro.GenericAvroDeserializer;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Deserializer;

@InterfaceStability.Evolving
public class GenericAvroConsumerConfig
extends BaseAvroConsumerConfig<GenericRecord, GenericRecord> {
    private GenericAvroConsumerConfig(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    extends BaseAvroConsumerConfig.Builder<GenericRecord, GenericRecord, T> {
        public Builder() {
            super.setKeyDeserializer(GenericAvroDeserializer.class.getName());
            super.setValueDeserializer(GenericAvroDeserializer.class.getName());
        }

        @Override
        public T setKeyDeserializer(String keyDeserializerClassName) {
            throw new ClientException("Not allowed to override key deserializer");
        }

        @Override
        public T setKeyDeserializer(Deserializer<GenericRecord> keyDeserializer) {
            throw new ClientException("Not allowed to override key deserializer");
        }

        @Override
        public T setValueDeserializer(String valueDeserializerClassName) {
            throw new ClientException("Not allowed to override value deserializer");
        }

        @Override
        public T setValueDeserializer(Deserializer<GenericRecord> valueDeserializer) {
            throw new ClientException("Not allowed to override value deserializer");
        }

        @Override
        public GenericAvroConsumerConfig build() {
            this.validate();
            return new GenericAvroConsumerConfig(this);
        }
    }
}

