/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.config;

import io.axual.client.config.BaseAvroProducerConfig;
import io.axual.common.annotation.InterfaceStability;
import io.axual.common.exception.ClientException;
import io.axual.serde.avro.GenericAvroSerializer;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Serializer;

@InterfaceStability.Evolving
public class GenericAvroProducerConfig
extends BaseAvroProducerConfig<GenericRecord, GenericRecord> {
    private GenericAvroProducerConfig(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    extends BaseAvroProducerConfig.Builder<GenericRecord, GenericRecord, T> {
        Builder() {
            super.setKeySerializer(GenericAvroSerializer.class.getName());
            super.setValueSerializer(GenericAvroSerializer.class.getName());
        }

        @Override
        public T setKeySerializer(String keySerializerClassName) {
            throw new ClientException("Not allowed to override key serializer");
        }

        @Override
        public T setKeySerializer(Serializer<GenericRecord> keySerializer) {
            throw new ClientException("Not allowed to override key serializer");
        }

        @Override
        public T setValueSerializer(String valueSerializerClassName) {
            throw new ClientException("Not allowed to override value serializer");
        }

        @Override
        public T setValueSerializer(Serializer<GenericRecord> valueSerializer) {
            throw new ClientException("Not allowed to override value serializer");
        }

        @Override
        public GenericAvroProducerConfig build() {
            this.validate();
            return new GenericAvroProducerConfig(this);
        }
    }
}

