/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.config;

import io.axual.client.config.BaseAvroConsumerConfig;
import io.axual.common.annotation.InterfaceStability;
import io.axual.common.exception.ClientException;
import io.axual.serde.avro.SpecificAvroDeserializer;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.serialization.Deserializer;

@InterfaceStability.Evolving
public class SpecificAvroConsumerConfig<K extends SpecificRecord, V extends SpecificRecord>
extends BaseAvroConsumerConfig<K, V> {
    private SpecificAvroConsumerConfig(Builder<K, V, ?> builder) {
        super(builder);
    }

    public static <K extends SpecificRecord, V extends SpecificRecord> Builder<K, V, ?> builder() {
        return new Builder();
    }

    public static class Builder<K extends SpecificRecord, V extends SpecificRecord, T extends Builder<K, V, T>>
    extends BaseAvroConsumerConfig.Builder<K, V, T> {
        public Builder() {
            super.setKeyDeserializer(SpecificAvroDeserializer.class.getName());
            super.setValueDeserializer(SpecificAvroDeserializer.class.getName());
        }

        @Override
        public T setKeyDeserializer(String keyDeserializerClassName) {
            throw new ClientException("Not allowed to override key deserializer class");
        }

        @Override
        public T setKeyDeserializer(Deserializer<K> keyDeserializer) {
            throw new ClientException("Not allowed to override key deserializer class");
        }

        @Override
        public T setValueDeserializer(String valueDeserializerClassName) {
            throw new ClientException("Not allowed to override value deserializer class");
        }

        @Override
        public T setValueDeserializer(Deserializer<V> valueDeserializer) {
            throw new ClientException("Not allowed to override value deserializer class");
        }

        @Override
        public SpecificAvroConsumerConfig<K, V> build() {
            this.validate();
            return new SpecificAvroConsumerConfig(this);
        }
    }
}

