/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.exception;

import io.axual.common.exception.ClientException;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;

public final class NoExistingSchemaException
extends ClientException {
    public static final int REQUEST_FORWARDING_FAILED_ERROR_CODE = 50003;
    public static final int UNKNOWN_MASTER_ERROR_CODE = 50004;
    private static final String KEY_FORMAT = "%s/subjects/%s-key/versions/latest";
    private static final String VALUE_FORMAT = "%s/subjects/%s-value/versions/latest";

    private NoExistingSchemaException(String urlKey, String urlValue, Throwable cause) {
        super(String.format("The used schema was not found on the stream, please check at %s (for the key) or %s (for the value)if you use the latest version of the schema.", urlKey, urlValue), cause);
    }

    public static void handleException(Exception e, String stream, String srUrls) {
        RestClientException restClientException;
        int errorCode;
        Throwable cause = e.getCause();
        if (cause instanceof RestClientException && ((errorCode = (restClientException = (RestClientException)cause).getErrorCode()) == 50003 || errorCode == 50004)) {
            String keyUrl = NoExistingSchemaException.getUrl(srUrls, stream, KEY_FORMAT);
            String valueUrl = NoExistingSchemaException.getUrl(srUrls, stream, VALUE_FORMAT);
            throw new NoExistingSchemaException(keyUrl, valueUrl, e);
        }
    }

    private static String getUrl(String srUrls, String stream, String format) {
        if (srUrls == null) {
            return null;
        }
        int index = srUrls.indexOf(44);
        String baseUrl = index < 0 ? srUrls : srUrls.substring(0, index);
        return String.format(format, baseUrl, stream);
    }
}

