/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.janitor;

import io.axual.common.concurrent.LockedObject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Janitor
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Janitor.class);
    private static final Map<Janitor, Boolean> janitorMap = new ConcurrentHashMap<Janitor, Boolean>();
    private static final Set<Janitor> janitors = Collections.newSetFromMap(janitorMap);
    private static LockedObject<Thread> shutDownThread = new LockedObject(null);
    private final Map<ManagedCloseable, Boolean> objectMap = new ConcurrentHashMap<ManagedCloseable, Boolean>();

    public Janitor() {
        try (LockedObject.WriteLock lock = shutDownThread.getWriteLock();){
            if (lock.getObject() == null) {
                lock.setObject((Object)new Thread((Runnable)new ShutDownHook(), "Janitor shutdown thread"));
                Runtime.getRuntime().addShutdownHook((Thread)lock.getObject());
            }
        }
        janitors.add(this);
    }

    @Override
    public void close() {
        for (Map.Entry<ManagedCloseable, Boolean> objectEntry : this.objectMap.entrySet()) {
            String type = objectEntry.getKey().getClass().getSimpleName();
            if (objectEntry.getValue().equals(Boolean.TRUE)) {
                LOG.warn("Cleaning up unclosed {}", (Object)type);
            }
            try {
                objectEntry.getKey().close();
            }
            catch (Exception swallow) {
                LOG.warn("Could not close {}", (Object)type, (Object)swallow);
            }
        }
        janitors.remove(this);
    }

    public <T extends ManagedCloseable> T register(T object) {
        return this.register(object, true);
    }

    public <T extends ManagedCloseable> T register(T object, boolean expectProperClose) {
        if (object.responsibleJanitor != null) {
            object.responsibleJanitor.objectMap.remove(object);
        }
        LOG.debug("Registering {}", (Object)object.getClass().getSimpleName());
        object.responsibleJanitor = this;
        this.objectMap.put(object, expectProperClose);
        return object;
    }

    private static final class ShutDownHook
    implements Runnable {
        private ShutDownHook() {
        }

        @Override
        public void run() {
            LOG.info("Janitor shutdown activated, cleaning up");
            for (Janitor janitor : janitors) {
                janitor.close();
            }
        }
    }

    public static class ManagedCloseable
    implements AutoCloseable {
        Janitor responsibleJanitor;

        @Override
        public void close() {
            if (this.responsibleJanitor != null) {
                if (this.responsibleJanitor.objectMap.remove(this) == null) {
                    LOG.warn("Closing an unregistered {}, potential double close", (Object)this.getClass().getSimpleName());
                } else {
                    LOG.debug("Unregistered {}", (Object)this.getClass().getSimpleName());
                }
            }
        }
    }
}

