/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.consumer.base;

import io.axual.client.consumer.ConsumerMessage;
import io.axual.serde.utils.HeaderUtils;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class BaseMessage<K, V>
implements ConsumerMessage<K, V> {
    private final ConsumerRecord<K, V> record;

    protected BaseMessage(ConsumerRecord<K, V> record) {
        this.record = record;
    }

    public ConsumerRecord<K, V> getRecord() {
        return this.record;
    }

    @Override
    public String getProducerId() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Producer-Id")) : null;
    }

    @Override
    public String getProducerVersion() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Producer-Version")) : null;
    }

    @Override
    public String getIntermediateId() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Intermediate-Id")) : null;
    }

    @Override
    public String getIntermediateVersion() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Intermediate-Version")) : null;
    }

    @Override
    public String getSystem() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-System")) : null;
    }

    @Override
    public String getComponent() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Cluster")) : null;
    }

    @Override
    public String getInstance() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Instance")) : null;
    }

    @Override
    public String getTenant() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Tenant")) : null;
    }

    @Override
    public String getEnvironment() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeStringHeader((Header)headers.lastHeader("Axual-Environment")) : null;
    }

    @Override
    public UUID getId() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeUuidHeader((Header)headers.lastHeader("Axual-Message-Id")) : null;
    }

    @Override
    public Long getSerializationTime() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeLongHeader((Header)headers.lastHeader("Axual-Serialization-Time")) : null;
    }

    @Override
    public Long getDeserializationTime() {
        Headers headers = this.record.headers();
        return headers != null ? HeaderUtils.decodeLongHeader((Header)headers.lastHeader("Axual-Deserialization-Time")) : null;
    }

    @Override
    public String getStream() {
        return this.record.topic();
    }

    @Override
    public int getPartition() {
        return this.record.partition();
    }

    @Override
    public long getOffset() {
        return this.record.offset();
    }

    @Override
    public long getTimestamp() {
        return this.record.timestamp();
    }

    @Override
    public K getKey() {
        return (K)this.record.key();
    }

    @Override
    public V getValue() {
        return (V)this.record.value();
    }
}

