/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.converter;

import io.axual.client.converter.AvroConverter;
import io.axual.client.exception.SchemaResolveException;
import io.axual.client.exception.SerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;

public class AvroJsonConverter
implements AvroConverter<String> {
    private final Schema schema;

    public AvroJsonConverter(Schema schema) {
        this.schema = schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String convertFrom(GenericRecord record) {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), (OutputStream)out);
            writer.write((Object)record, (Encoder)jsonEncoder);
            jsonEncoder.flush();
            String string = out.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new SerializationException("Error converting to JSON", e);
        }
    }

    @Override
    public GenericRecord convertTo(String json) {
        try {
            return (GenericRecord)new GenericDatumReader(this.schema).read(null, (Decoder)DecoderFactory.get().jsonDecoder(this.schema, json));
        }
        catch (SchemaResolveException e) {
            throw new SerializationException("Error getting schema for stream, SchemaRegistry might be down, or stream is not configured", (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new SerializationException("Error deserializing given JSON with the latest Schema from the stream", e);
        }
    }

    @Override
    public <S extends SpecificRecord> S toSpecific(String serializedRecord, Class<S> recordClass) {
        try {
            Schema classSchema = (Schema)recordClass.getField("SCHEMA$").get(null);
            return (S)((SpecificRecord)new SpecificDatumReader(classSchema).read(null, (Decoder)DecoderFactory.get().jsonDecoder(classSchema, serializedRecord)));
        }
        catch (IOException e) {
            throw new SerializationException("Error deserializing given JSON with the Schema from the class", e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new SerializationException("Error getting Schema from provided class", e);
        }
    }
}

