/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.exception;

import io.axual.common.exception.ClientException;
import java.time.Duration;

public class RetriableException
extends ClientException {
    private static final Duration DEFAULT_SLEEPTIME = Duration.ofMillis(1000L);
    private final Duration sleepTime;

    public RetriableException(Throwable cause) {
        this(cause, DEFAULT_SLEEPTIME);
    }

    @Deprecated
    public RetriableException(Throwable cause, long sleepTime) {
        this(cause, Duration.ofMillis(sleepTime));
    }

    public RetriableException(Throwable cause, Duration sleepTime) {
        super(String.format("Error during processing of message, retrying in %s.%nOriginal error: %s", sleepTime, cause.getMessage()), cause);
        this.sleepTime = sleepTime;
    }

    @Deprecated
    public RetriableException(long sleepTime) {
        this(Duration.ofMillis(sleepTime));
    }

    public RetriableException(Duration sleepTime) {
        super(String.format("Error during processing of message, retrying in %s.", sleepTime));
        this.sleepTime = sleepTime;
    }

    public Duration getSleepTime() {
        return this.sleepTime;
    }
}

