/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.producer.generic;

import io.axual.client.producer.ProducedMessage;
import io.axual.client.producer.ProducerMessage;
import io.axual.client.proxy.generic.producer.ExtendedProducerRecord;
import io.axual.serde.utils.HeaderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;

public class GenericProducedMessage<K, V>
implements ProducedMessage<K, V> {
    private final ProducerMessage<K, V> message;
    private final RecordMetadata metadata;
    private final Map<String, Object> context;

    public GenericProducedMessage(ProducerMessage<K, V> message, RecordMetadata metadata) {
        this.message = message;
        this.metadata = metadata;
        this.context = Collections.unmodifiableMap(message.getProducerRecord() instanceof ExtendedProducerRecord ? ((ExtendedProducerRecord)message.getProducerRecord()).context() : new HashMap());
    }

    @Override
    public ProducerMessage<K, V> getMessage() {
        return this.message;
    }

    @Override
    public String getSystem() {
        return this.getContextString("system");
    }

    @Override
    public String getInstance() {
        return this.getContextString("instance");
    }

    @Override
    public String getCluster() {
        return this.getContextString("cluster");
    }

    @Override
    public String getStream() {
        return this.metadata.topic();
    }

    @Override
    public int getPartition() {
        return this.metadata.partition();
    }

    @Override
    public long getOffset() {
        return this.metadata.offset();
    }

    @Override
    public Long getTimestamp() {
        return this.metadata.hasTimestamp() ? Long.valueOf(this.metadata.timestamp()) : null;
    }

    @Override
    public Long getSerializationTimestamp() {
        Header header = this.message.getProducerRecord().headers().lastHeader("Axual-Serialization-Time");
        return header != null ? HeaderUtils.decodeLongHeader((Header)header) : null;
    }

    private String getContextString(String key) {
        Object value = this.context.get(key);
        return value instanceof String ? (String)value : null;
    }
}

