/*
 * Decompiled with CFR 0.152.
 */
package io.axual.common.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    public static final String DEFAULT_PASSWORD = "notsecret";
    public static final String KEYSTORE_JKS_PATH = "/ssl/axual.client.keystore.jks";
    public static final String KEYSTORE_PEM_PATH = "/ssl/axual.client.keystore.pem";
    public static final String TRUSTSTORE_JKS_PATH = "/ssl/axual.client.truststore.jks";
    public static final String TRUSTSTORE_PEM_PATH = "/ssl/axual.client.truststore.pem";

    private TestUtils() {
    }

    public static File createDirectoryAndFile(String dir, String fileName) throws IOException {
        return TestUtils.createFile(TestUtils.createDirectory(dir).getAbsolutePath(), fileName).getParentFile();
    }

    public static File createDirectory(String dirPath) throws IOException {
        if (dirPath == null || dirPath.trim().isEmpty()) {
            throw new IOException("Unable to create directory; Reason: Directory path found null.");
        }
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createFile(String dir, String fileName) throws IOException {
        if (dir == null || dir.trim().isEmpty() || fileName == null || fileName.trim().isEmpty()) {
            throw new IOException("Unable to create file; Reason: Directory or File name is either null or empty.");
        }
        File file = new File(dir, fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.createNewFile()) {
            throw new IOException("Unable to create file");
        }
        return file;
    }

    public static void deleteDirectory(File dir) throws IOException {
        if (dir != null && dir.exists()) {
            for (File file : dir.listFiles()) {
                Files.delete(file.toPath());
            }
            Files.delete(dir.toPath());
        }
    }

    public static InputStream getResourceAsStream(String name) {
        return TestUtils.class.getClassLoader().getResourceAsStream(name);
    }

    public static String getAbsolutePath(String resourceName) {
        Properties props = new Properties();
        try {
            props.load(TestUtils.getResourceAsStream("properties-from-pom.properties"));
        }
        catch (IOException e) {
            LOG.error(String.format("Could not get path of file %s", resourceName), (Throwable)e);
            return resourceName;
        }
        String base = props.getProperty("common.resources.basedir");
        return base + "/" + resourceName;
    }

    public static String getFileContentsAsString(String resourceName) {
        try {
            Path path = Paths.get(resourceName, new String[0]);
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            LOG.error(String.format("Could not get contents of file %s", resourceName), (Throwable)e);
            return resourceName;
        }
    }
}

