/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client;

import io.axual.discovery.client.DiscoveryClient;
import io.axual.discovery.client.DiscoveryConfig;
import io.axual.discovery.client.DiscoveryResult;
import io.axual.discovery.client.exception.DiscoveryClientRegistrationException;
import io.axual.discovery.client.fetcher.DiscoveryLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryClientRegistry.class);
    private static final Map<DiscoveryConfig, DiscoveryClientsList> clients = new HashMap<DiscoveryConfig, DiscoveryClientsList>();
    private static final ReentrantLock lock = new ReentrantLock();

    private DiscoveryClientRegistry() {
    }

    public static void register(DiscoveryConfig config, DiscoveryClient client) throws DiscoveryClientRegistrationException {
        lock.lock();
        try {
            if (!clients.containsKey(config)) {
                DiscoveryLoader loader = new DiscoveryLoader(config);
                clients.put(config, new DiscoveryClientsList(loader));
            }
            DiscoveryClientsList reg = clients.get(config);
            reg.clients.add(client);
            client.onDiscoveryPropertiesChange(reg.loader.getDiscoveryResult());
        }
        catch (Exception e) {
            throw new DiscoveryClientRegistrationException("An exception occurred while trying to register the DiscoveryClient", e);
        }
        finally {
            lock.unlock();
        }
    }

    public static void invalidate(DiscoveryConfig config) {
        lock.lock();
        try {
            DiscoveryClientsList reg = clients.get(config);
            if (reg != null) {
                reg.loader.invalidate();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(DiscoveryConfig config, DiscoveryClient client) {
        block8: {
            lock.lock();
            try {
                DiscoveryClientsList reg = clients.get(config);
                if (reg == null) break block8;
                reg.clients.remove(client);
                if (!reg.clients.isEmpty()) break block8;
                try {
                    reg.loader.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception occurred while closing the DiscoveryLoader", (Throwable)e);
                }
                finally {
                    clients.remove(config);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkProperties(DiscoveryConfig config) {
        if (lock.tryLock()) {
            try {
                DiscoveryClientsList reg = clients.get(config);
                if (reg != null && reg.loader.discoveryChanged()) {
                    LOG.info("Reloading discovery: appId={}, endpoint={}", (Object)config.getApplicationId(), (Object)config.getEndpoint());
                    DiscoveryResult discoveryResult = reg.loader.getDiscoveryResult();
                    for (DiscoveryClient proxy : reg.clients) {
                        proxy.onDiscoveryPropertiesChange(discoveryResult);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void cleanUp() {
        lock.lock();
        try {
            for (DiscoveryClientsList clientList : clients.values()) {
                try {
                    clientList.loader.close();
                }
                catch (Exception e) {
                    LOG.warn("Could not close Discovery Loader", (Throwable)e);
                }
            }
            clients.clear();
        }
        finally {
            lock.unlock();
        }
    }

    private static class DiscoveryClientsList {
        private final DiscoveryLoader loader;
        private final Set<DiscoveryClient> clients = new HashSet<DiscoveryClient>();

        DiscoveryClientsList(DiscoveryLoader loader) {
            this.loader = loader;
        }
    }
}

