/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client;

import io.axual.common.config.SslConfig;
import io.axual.common.tools.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class DiscoveryConfig {
    private final String applicationId;
    private final String applicationVersion;
    private final String endpoint;
    private final Map<String, String> parameters;
    private final SslConfig sslConfig;

    private DiscoveryConfig(Builder builder) {
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.endpoint = builder.endpoint;
        this.parameters = new TreeMap<String, String>();
        if (builder.parameters != null) {
            this.parameters.putAll(builder.parameters);
        }
        this.sslConfig = builder.sslConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryConfig other = (DiscoveryConfig)o;
        if (!Objects.equals(this.applicationId, other.applicationId)) {
            return false;
        }
        if (!Objects.equals(this.applicationVersion, other.applicationVersion)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, other.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        return Objects.equals(this.sslConfig, other.sslConfig);
    }

    public int hashCode() {
        int result = this.applicationId != null ? this.applicationId.hashCode() : 0;
        result = 31 * result + (this.applicationVersion != null ? this.applicationVersion.hashCode() : 0);
        result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.sslConfig != null ? this.sslConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return StringUtil.join((String)",", (String[])new String[]{this.applicationId, this.applicationVersion, this.endpoint, this.parameters.toString(), this.sslConfig != null ? this.sslConfig.toString() : "null"});
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public static class Builder {
        private String applicationId;
        private String applicationVersion = "unknown";
        private String endpoint;
        private Map<String, String> parameters;
        private SslConfig sslConfig;

        public String getApplicationId() {
            return this.applicationId;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public String getApplicationVersion() {
            return this.applicationVersion;
        }

        public Builder setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public SslConfig getSslConfig() {
            return this.sslConfig;
        }

        public Builder setSslConfig(SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public DiscoveryConfig build() {
            return new DiscoveryConfig(this);
        }
    }
}

