/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client;

import io.axual.common.tools.MapUtil;
import io.axual.common.tools.ParseUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DiscoveryResult {
    public static final String TENANT_PROPERTY = "tenant";
    public static final String INSTANCE_PROPERTY = "instance";
    public static final String ENVIRONMENT_PROPERTY = "environment";
    public static final String SYSTEM_PROPERTY = "system";
    public static final String CLUSTER_PROPERTY = "cluster";
    public static final String TTL_PROPERTY = "ttl";
    private static final long DEFAULT_TTL = 10000L;
    private final Map<String, Object> properties;
    private final long timestamp;

    public DiscoveryResult() {
        this.properties = Collections.unmodifiableMap(new HashMap());
        this.timestamp = System.currentTimeMillis();
    }

    public DiscoveryResult(Properties props) {
        this.properties = Collections.unmodifiableMap(MapUtil.objectToStringMap((Map)props));
        this.timestamp = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof DiscoveryResult) {
            return this.properties.equals(((DiscoveryResult)o).properties);
        }
        return false;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTenant() {
        return MapUtil.stringValue(this.properties, (Object)TENANT_PROPERTY);
    }

    public String getInstance() {
        return MapUtil.stringValue(this.properties, (Object)INSTANCE_PROPERTY);
    }

    public String getEnvironment() {
        return MapUtil.stringValue(this.properties, (Object)ENVIRONMENT_PROPERTY);
    }

    public String getSystem() {
        return MapUtil.stringValue(this.properties, (Object)SYSTEM_PROPERTY);
    }

    public String getCluster() {
        return MapUtil.stringValue(this.properties, (Object)CLUSTER_PROPERTY);
    }

    public long getTtl() {
        return ParseUtil.parseLong((String)MapUtil.stringValue(this.properties, (Object)TTL_PROPERTY), (long)10000L);
    }

    public Map<String, Object> getConfigs() {
        return this.properties;
    }

    public String toString() {
        return "DiscoveryResult: " + this.properties.toString();
    }
}

