/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client.fetcher;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axual.common.config.SslConfig;
import io.axual.common.tools.SslUtil;
import io.axual.discovery.client.DiscoveryConfig;
import io.axual.discovery.client.DiscoveryResult;
import io.axual.discovery.client.exception.ConfigurationFetchFailedException;
import io.axual.discovery.client.exception.DiscoveryException;
import io.axual.discovery.client.tools.VersionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryFetcher
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryFetcher.class);
    private static final String HTTP_SCHEME = "http://";
    private static final String HTTPS_SCHEME = "https://";
    private final TypeReference<Properties> propertiesTypeReference = new TypeReference<Properties>(){};
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DiscoveryConfig config;
    private final CloseableHttpClient httpClient;
    private boolean isClosed = false;

    public DiscoveryFetcher(DiscoveryConfig config) {
        this.config = config;
        if (!this.isHyperTextUrl(config.getEndpoint())) {
            throw new DiscoveryException(config.getEndpoint() + " is not a valid URL");
        }
        try {
            this.httpClient = this.createHttpClient();
        }
        catch (Exception e) {
            throw new DiscoveryException("Error found during httpClient configuration", e);
        }
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder builder = HttpClients.custom().setDefaultHeaders(Arrays.asList(new BasicHeader("Cache-Control", "no-cache"), new BasicHeader("X-Application-Id", this.config.getApplicationId()), new BasicHeader("X-Application-Version", this.config.getApplicationVersion()), new BasicHeader("X-Client-Library-Version", VersionUtil.getProjectVersion(this.getClass()))));
        if (this.config.getEndpoint().startsWith(HTTPS_SCHEME)) {
            if (!this.config.getSslConfig().getEnableHostnameVerification()) {
                builder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            }
            builder.setSSLContext(SslUtil.createSslContext((SslConfig)this.config.getSslConfig()));
        }
        return builder.build();
    }

    private String getUrl(String lastCluster) {
        String url = this.config.getEndpoint();
        if (this.isHyperTextUrl(url)) {
            StringBuilder builder = new StringBuilder(url);
            if (!url.endsWith("/")) {
                builder.append("/");
            }
            builder.append("?applicationId=");
            builder.append(this.config.getApplicationId());
            if (lastCluster != null) {
                builder.append("&lastCluster=");
                builder.append(lastCluster);
            }
            for (Map.Entry<String, String> entry : this.config.getParameters().entrySet()) {
                builder.append("&");
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
            }
            return builder.toString();
        }
        throw new IllegalArgumentException("Provided URL, " + this.config.getEndpoint() + " was invalid");
    }

    public DiscoveryResult executeRequest(String lastCluster) {
        if (this.isClosed) {
            throw new DiscoveryException("Illegal call, DiscoveryFetcher is closed");
        }
        String url = this.getUrl(lastCluster);
        LOG.debug("Fetching Discovery API properties from {}", (Object)url);
        Properties properties = null;
        try {
            if (this.isHyperTextUrl(url)) {
                properties = this.execute(url);
            }
        }
        catch (Exception e) {
            throw new ConfigurationFetchFailedException(url, e);
        }
        LOG.debug("Fetched Discovery API properties: {}", (Object)properties);
        return properties != null && !properties.isEmpty() ? new DiscoveryResult(properties) : null;
    }

    private boolean isHyperTextUrl(String url) {
        return url.startsWith(HTTPS_SCHEME) || url.startsWith(HTTP_SCHEME);
    }

    private Properties execute(String url) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(url));
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 200) {
            try (InputStream is = response.getEntity().getContent();){
                Properties properties = (Properties)this.objectMapper.readValue(is, this.propertiesTypeReference);
                return properties;
            }
        }
        if (responseCode == 204) {
            LOG.info("Empty response from Discovery API, no active clusters found");
            return new Properties();
        }
        if (responseCode == 403) {
            LOG.warn("Forbidden to query Discovery API");
        } else {
            LOG.warn("Unexpected response code from Discovery API: {}", (Object)responseCode);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        LOG.debug("Closing Discovery Fetcher");
        if (!this.isClosed) {
            this.httpClient.close();
            this.isClosed = true;
        }
    }
}

