/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client.fetcher;

import io.axual.discovery.client.DiscoveryConfig;
import io.axual.discovery.client.DiscoveryResult;
import io.axual.discovery.client.exception.DiscoveryException;
import io.axual.discovery.client.fetcher.DiscoveryFetcher;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryLoader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryLoader.class);
    private static final long BACKOFF_PERIOD = 10000L;
    private final DiscoveryFetcher fetcher;
    private long lastFetchTimestamp;
    private long ttl;
    private String lastCluster = null;
    private DiscoveryResult lastResult;
    private boolean firstFetch = true;
    private boolean isClosed = false;

    public DiscoveryLoader(DiscoveryConfig config) {
        this.fetcher = new DiscoveryFetcher(config);
    }

    public DiscoveryResult getDiscoveryResult() {
        this.discoveryChanged();
        return this.lastResult;
    }

    public void invalidate() {
        if (this.isClosed) {
            throw new DiscoveryException("Illegal call, DiscoveryLoader is closed");
        }
        this.lastFetchTimestamp = 0L;
    }

    public boolean discoveryChanged() {
        if (this.isClosed) {
            throw new DiscoveryException("Illegal call, DiscoveryLoader is closed");
        }
        if (this.firstFetch) {
            this.firstFetch = false;
            this.lastResult = this.loadFromDiscovery();
            LOG.info("Fetched discovery properties: {}", (Object)this.lastResult);
            return true;
        }
        DiscoveryResult newResult = this.loadFromDiscovery();
        if (!Objects.equals(newResult, this.lastResult)) {
            LOG.info("Change in discovery properties, new properties: {}", (Object)newResult);
            this.lastResult = newResult;
            return true;
        }
        LOG.trace("No change in discovery properties: {}", (Object)newResult);
        return false;
    }

    private DiscoveryResult loadFromDiscovery() {
        if (System.currentTimeMillis() - this.lastFetchTimestamp >= this.ttl) {
            try {
                LOG.trace("{} configuration", (Object)(this.lastResult == null ? "Loading" : "Reloading"));
                DiscoveryResult result = this.fetcher.executeRequest(this.lastCluster);
                this.lastFetchTimestamp = System.currentTimeMillis();
                if (result != null) {
                    this.lastCluster = result.getCluster();
                    long newTtl = result.getTtl();
                    if (newTtl != this.ttl) {
                        LOG.info("TTL updated to: {} (was: {})", (Object)newTtl, (Object)this.ttl);
                        this.ttl = newTtl;
                    }
                } else {
                    this.ttl = 10000L;
                }
                LOG.trace("Reloaded configuration from discovery: {}", (Object)result);
                return result;
            }
            catch (Exception e) {
                LOG.warn("Could not reload configuration", (Throwable)e);
                this.lastFetchTimestamp = System.currentTimeMillis() - this.ttl + 10000L;
            }
        }
        return this.lastResult;
    }

    @Override
    public void close() throws Exception {
        LOG.debug("Closing Discovery Loader");
        if (!this.isClosed) {
            this.fetcher.close();
            this.isClosed = true;
        }
    }
}

