/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client.tools;

import io.axual.common.config.ConfigParser;
import io.axual.common.tools.KafkaUtil;
import io.axual.discovery.client.DiscoveryConfig;
import java.util.Map;

public abstract class DiscoveryConfigParser {
    private final String endpointSuffix;

    public DiscoveryConfigParser(String endpointSuffix) {
        this.endpointSuffix = endpointSuffix;
    }

    protected DiscoveryConfig parse(Map input, Map<String, String> parameters) {
        String applicationId = ConfigParser.parseStringConfig((Map)input, (String)"app.id", (boolean)true, null);
        String applicationVersion = ConfigParser.parseStringConfig((Map)input, (String)"app.version", (boolean)false, (String)"unknown");
        String propertyName = input.containsKey("endpoint") ? "endpoint" : "bootstrap.servers";
        String endpoint = ConfigParser.parseStringConfig((Map)input, (String)propertyName, (boolean)true, null);
        String suffix = this.endpointSuffix;
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        endpoint = endpoint.endsWith("/") ? endpoint + suffix : endpoint + "/" + suffix;
        return DiscoveryConfig.newBuilder().setApplicationId(applicationId).setApplicationVersion(applicationVersion).setEndpoint(endpoint).setParameters(parameters).setSslConfig(KafkaUtil.parseSslConfig((Map)input)).build();
    }
}

