/*
 * Decompiled with CFR 0.152.
 */
package io.axual.discovery.client.tools;

import io.axual.common.config.ClientConfig;
import io.axual.common.config.ConfigParser;
import io.axual.discovery.client.DiscoveryConfig;
import io.axual.discovery.client.tools.DiscoveryConfigParser;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryConfigParserV2
extends DiscoveryConfigParser {
    private static final String V2_ENDPOINT_SUFFIX = "v2";
    private static final String DISCOVERY_TENANT_PARAM = "tenant";
    private static final String DISCOVERY_ENVIRONMENT_PARAM = "env";

    public DiscoveryConfigParserV2() {
        super(V2_ENDPOINT_SUFFIX);
    }

    public static DiscoveryConfig getDiscoveryConfig(ClientConfig config) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DISCOVERY_TENANT_PARAM, config.getTenant());
        parameters.put(DISCOVERY_ENVIRONMENT_PARAM, config.getEnvironment());
        String url = config.getEndpoint();
        String versionTwo = url.endsWith("/") ? V2_ENDPOINT_SUFFIX : "/v2";
        return DiscoveryConfig.newBuilder().setApplicationId(config.getApplicationId()).setApplicationVersion(config.getApplicationVersion()).setEndpoint(url + versionTwo).setParameters(parameters).setSslConfig(config.getSslConfig()).build();
    }

    public DiscoveryConfig parse(Map input) {
        String tenant = ConfigParser.parseStringConfig((Map)input, (String)DISCOVERY_TENANT_PARAM, (boolean)true, null);
        String environment = ConfigParser.parseStringConfig((Map)input, (String)"environment", (boolean)false, null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DISCOVERY_TENANT_PARAM, tenant);
        if (environment != null) {
            parameters.put(DISCOVERY_ENVIRONMENT_PARAM, environment);
        }
        return super.parse(input, parameters);
    }
}

