/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.stream;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.basestar.auth.Caller;
import io.basestar.database.event.ObjectCreatedEvent;
import io.basestar.database.event.ObjectDeletedEvent;
import io.basestar.database.event.ObjectRefreshedEvent;
import io.basestar.database.event.ObjectUpdatedEvent;
import io.basestar.event.Emitter;
import io.basestar.event.Event;
import io.basestar.event.Handlers;
import io.basestar.expression.Context;
import io.basestar.expression.Expression;
import io.basestar.expression.ExpressionVisitor;
import io.basestar.schema.Index;
import io.basestar.schema.Instance;
import io.basestar.schema.Namespace;
import io.basestar.schema.ObjectSchema;
import io.basestar.storage.PartitionedStorage;
import io.basestar.storage.exception.UnsupportedQueryException;
import io.basestar.storage.query.DisjunctionVisitor;
import io.basestar.storage.query.RangeVisitor;
import io.basestar.stream.Change;
import io.basestar.stream.Hub;
import io.basestar.stream.Publisher;
import io.basestar.stream.Subscription;
import io.basestar.stream.SubscriptionInfo;
import io.basestar.stream.Subscriptions;
import io.basestar.stream.event.SubscriptionPublishEvent;
import io.basestar.stream.event.SubscriptionQueryEvent;
import io.basestar.util.Name;
import io.basestar.util.Nullsafe;
import io.basestar.util.Pager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DefaultHub
implements Hub {
    private static final int SUBSCRIPTION_PAGE_SIZE = 50;
    private static final Handlers<DefaultHub> HANDLERS = Handlers.builder().on(ObjectCreatedEvent.class, DefaultHub::onObjectCreated).on(ObjectUpdatedEvent.class, DefaultHub::onObjectUpdated).on(ObjectDeletedEvent.class, DefaultHub::onObjectDeleted).on(ObjectRefreshedEvent.class, DefaultHub::onObjectRefreshed).on(SubscriptionQueryEvent.class, DefaultHub::onSubscriptionQuery).on(SubscriptionPublishEvent.class, DefaultHub::onSubscriptionPublish).build();
    private final Subscriptions subscriptions;
    private final Publisher publisher;
    private final Namespace namespace;
    private final Emitter emitter;

    DefaultHub(Subscriptions subscriptions, Publisher publisher, Namespace namespace, Emitter emitter) {
        this.subscriptions = (Subscriptions)Nullsafe.require((Object)subscriptions);
        this.publisher = (Publisher)Nullsafe.require((Object)publisher);
        this.namespace = (Namespace)Nullsafe.require((Object)namespace);
        this.emitter = (Emitter)Nullsafe.require((Object)emitter);
    }

    public CompletableFuture<?> handle(Event event, Map<String, String> meta) {
        return HANDLERS.handle((Object)this, event, meta);
    }

    @Override
    public CompletableFuture<?> subscribe(Caller caller, String sub, String channel, String schemaName, Expression expression, Set<Name> expand, SubscriptionInfo info) {
        ObjectSchema schema = this.namespace.requireObjectSchema(schemaName);
        Expression bound = expression.bind(Context.init());
        Set<Subscription.Key> keys = DefaultHub.keys(schema, expression, expand);
        return this.subscriptions.subscribe(caller, sub, channel, keys, bound, info);
    }

    @Override
    public CompletableFuture<?> unsubscribe(Caller caller, String sub, String channel) {
        return this.subscriptions.unsubscribe(sub, channel);
    }

    @Override
    public CompletableFuture<?> unsubscribeAll(Caller caller, String sub) {
        return this.subscriptions.unsubscribeAll(sub);
    }

    private CompletableFuture<?> onObjectCreated(ObjectCreatedEvent event) {
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        Map after = event.getAfter();
        Set<Subscription.Key> keys = DefaultHub.keys(schema, after);
        return this.emitter.emit((Event)SubscriptionQueryEvent.of(schema.getQualifiedName(), event.getId(), Change.Event.CREATE, null, after, keys));
    }

    private CompletableFuture<?> onObjectUpdated(ObjectUpdatedEvent event) {
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        Map before = event.getBefore();
        Map after = event.getAfter();
        Sets.SetView keys = Sets.union(DefaultHub.keys(schema, after), DefaultHub.keys(schema, before));
        return this.emitter.emit((Event)SubscriptionQueryEvent.of(schema.getQualifiedName(), event.getId(), Change.Event.UPDATE, before, after, (Set<Subscription.Key>)keys));
    }

    private CompletableFuture<?> onObjectDeleted(ObjectDeletedEvent event) {
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        Map before = event.getBefore();
        Set<Subscription.Key> keys = DefaultHub.keys(schema, before);
        return this.emitter.emit((Event)SubscriptionQueryEvent.of(schema.getQualifiedName(), event.getId(), Change.Event.DELETE, before, null, keys));
    }

    private CompletableFuture<?> onObjectRefreshed(ObjectRefreshedEvent event) {
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        Map before = event.getBefore();
        Map after = event.getAfter();
        Sets.SetView keys = Sets.union(DefaultHub.keys(schema, after), DefaultHub.keys(schema, before));
        return this.emitter.emit((Event)SubscriptionQueryEvent.of(schema.getQualifiedName(), event.getId(), Change.Event.REFRESH, before, null, (Set<Subscription.Key>)keys));
    }

    private CompletableFuture<?> onSubscriptionQuery(SubscriptionQueryEvent event) {
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        Set<Subscription.Key> keys = event.getKeys();
        Comparator<Subscription> comparator = Subscription.COMPARATOR;
        Pager pager = new Pager(comparator, this.subscriptions.query(keys), event.getPaging());
        return pager.page(50).thenCompose(results -> {
            ArrayList<SubscriptionQueryEvent> events = new ArrayList<SubscriptionQueryEvent>();
            results.forEach(result -> events.add((SubscriptionQueryEvent)((Object)SubscriptionPublishEvent.of(schema.getQualifiedName(), event.getId(), event.getEvent(), event.getBefore(), event.getAfter(), result))));
            if (results.hasMore()) {
                events.add(event.withPaging(results.getPaging()));
            }
            return this.emitter.emit(events);
        });
    }

    private CompletableFuture<?> onSubscriptionPublish(SubscriptionPublishEvent event) {
        Instance after;
        ObjectSchema schema = this.namespace.requireObjectSchema(event.getSchema());
        String id = event.getId();
        Subscription subscription = event.getSubscription();
        Caller caller = subscription.getCaller();
        Expression expression = subscription.getExpression();
        Instance before = event.getBefore() == null ? null : (Instance)schema.create(event.getBefore());
        Instance instance = after = event.getAfter() == null ? null : (Instance)schema.create(event.getAfter());
        if (this.match((Map<String, Object>)before, expression) || this.match((Map<String, Object>)after, expression)) {
            Change change = Change.of(event.getEvent(), schema.getQualifiedName(), id, (Map<String, Object>)before, (Map<String, Object>)after);
            return this.publisher.publish(caller, schema, subscription.getSub(), subscription.getChannel(), subscription.getInfo(), change);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean match(Map<String, Object> object, Expression expression) {
        if (object != null) {
            return expression.evaluatePredicate(Context.init(object));
        }
        return false;
    }

    private static Subscription.Key idKey(ObjectSchema schema, String id) {
        return new Subscription.Key(schema.getQualifiedName(), "__id", (List<Object>)ImmutableList.of((Object)id));
    }

    private static Set<Subscription.Key> keys(ObjectSchema schema, Expression expression, Set<Name> expand) {
        Set disjunction = (Set)expression.visit((ExpressionVisitor)new DisjunctionVisitor());
        HashSet<Subscription.Key> keys = new HashSet<Subscription.Key>();
        for (Expression conjunction : disjunction) {
            Map query = (Map)conjunction.visit((ExpressionVisitor)new RangeVisitor());
            Optional optId = PartitionedStorage.constantId((Map)query);
            if (optId.isPresent()) {
                keys.add(DefaultHub.idKey(schema, (String)optId.get()));
                continue;
            }
            Optional optSatisfy = PartitionedStorage.satisfy(schema.getIndexes().values(), (Map)query, Collections.emptyList());
            if (optSatisfy.isPresent()) {
                PartitionedStorage.SatisfyResult satisfy = (PartitionedStorage.SatisfyResult)optSatisfy.get();
                Index index = satisfy.getIndex();
                keys.add(new Subscription.Key(schema.getQualifiedName(), index.getName(), satisfy.getPartition()));
                continue;
            }
            throw new UnsupportedQueryException(schema.getQualifiedName(), expression, "no index");
        }
        return keys;
    }

    private static Set<Subscription.Key> keys(ObjectSchema schema, Map<String, Object> object) {
        HashSet<Subscription.Key> keys = new HashSet<Subscription.Key>();
        keys.add(DefaultHub.idKey(schema, Instance.getId(object)));
        for (Index index : schema.getIndexes().values()) {
            index.readValues(object).forEach((k, projection) -> keys.add(new Subscription.Key(schema.getQualifiedName(), index.getName(), k.getPartition())));
        }
        return keys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Subscriptions subscriptions;
        private Publisher publisher;
        private Namespace namespace;
        private Emitter emitter;

        Builder() {
        }

        public Builder subscriptions(Subscriptions subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public Builder publisher(Publisher publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder emitter(Emitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public DefaultHub build() {
            return new DefaultHub(this.subscriptions, this.publisher, this.namespace, this.emitter);
        }

        public String toString() {
            return "DefaultHub.Builder(subscriptions=" + this.subscriptions + ", publisher=" + this.publisher + ", namespace=" + this.namespace + ", emitter=" + this.emitter + ")";
        }
    }
}

