/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.stream;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.basestar.auth.Caller;
import io.basestar.expression.Expression;
import io.basestar.stream.Subscription;
import io.basestar.stream.SubscriptionInfo;
import io.basestar.stream.Subscriptions;
import io.basestar.util.Page;
import io.basestar.util.Pager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class MemorySubscriptions
implements Subscriptions {
    private final Map<Subscription.Id, Subscription> subscriptions = new HashMap<Subscription.Id, Subscription>();
    private final Multimap<Subscription.Key, Subscription.Id> keyToId = HashMultimap.create();
    private final Multimap<Subscription.Id, Subscription.Key> idToKey = HashMultimap.create();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> subscribe(Caller caller, String sub, String channel, Set<Subscription.Key> keys, Expression expression, SubscriptionInfo info) {
        Subscription subscription = new Subscription();
        subscription.setCaller(caller);
        subscription.setSub(sub);
        subscription.setChannel(channel);
        subscription.setExpression(expression);
        subscription.setInfo(info);
        Object object = this.lock;
        synchronized (object) {
            Subscription.Id id = new Subscription.Id(sub, channel);
            this.subscriptions.put(id, subscription);
            keys.forEach(key -> {
                this.keyToId.put(key, (Object)id);
                this.idToKey.put((Object)id, key);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pager.Source<Subscription>> query(Set<Subscription.Key> keys) {
        ArrayList results = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            HashSet ids = new HashSet();
            keys.forEach(key -> ids.addAll(this.keyToId.get(key)));
            ids.forEach(id -> results.add(this.subscriptions.get(id)));
        }
        return Collections.singletonList((count, token, stats) -> CompletableFuture.completedFuture(Page.from((List)results)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> unsubscribe(String sub, String channel) {
        Object object = this.lock;
        synchronized (object) {
            Subscription.Id id = new Subscription.Id(sub, channel);
            this.idToKey.get((Object)id).forEach(key -> this.keyToId.remove(key, (Object)id));
            this.idToKey.removeAll((Object)id);
            this.subscriptions.remove(id);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> unsubscribeAll(String sub) {
        Object object = this.lock;
        synchronized (object) {
            HashSet ids = new HashSet();
            this.subscriptions.forEach((id, subscription) -> {
                if (sub.equals(subscription.getSub())) {
                    ids.add(id);
                }
            });
            ids.forEach(id -> {
                this.idToKey.get(id).forEach(key -> this.keyToId.remove(key, id));
                this.idToKey.removeAll(id);
                this.subscriptions.remove(id);
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

