/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client.context.definition;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bindingz.api.client.context.definition.DefinitionReader;
import io.bindingz.api.client.context.definition.model.Definition;
import io.bindingz.api.client.context.definition.model.ProcessConfiguration;
import io.bindingz.api.client.context.definition.model.ProcessContractDefinition;
import io.bindingz.api.client.context.definition.model.PublishConfiguration;
import io.bindingz.api.client.context.definition.model.PublishContractDefinition;
import io.bindingz.api.client.jackson.DefaultPublishConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonDefinitionReader
implements DefinitionReader {
    private ObjectMapper mapper = new ObjectMapper();
    private static final String DEFAULT_PUBLISH_CONFIGURATION = DefaultPublishConfigurationFactory.class.getName();
    private static Map<String, String> DEFAULT_TYPE_MAPPINGS = new HashMap<String, String>();
    private static final String DEFAULT_SOURCE_CODE_PROVIDER = "JSONSCHEMA2POJO";
    private static Map<String, String> DEFAULT_SOURCE_CODE_CONFIGURATION = new HashMap<String, String>();

    @Override
    public Definition read(String fileName) {
        try {
            return this.enrich((Definition)this.mapper.readValue(new File(fileName), Definition.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read definition file: " + fileName, e);
        }
    }

    private Definition enrich(Definition definition) {
        Definition.DefinitionBuilder builder = Definition.builder();
        builder = definition.getProcess() != null ? builder.process(this.transform(definition, definition.getProcess())) : builder;
        builder = definition.getPublish() != null ? builder.publish(this.transform(definition, definition.getPublish())) : builder;
        return builder.build();
    }

    private PublishConfiguration transform(Definition definition, PublishConfiguration publishConfiguration) {
        PublishConfiguration defaulted = publishConfiguration.withConfigurationFactoryClass(this.override(DEFAULT_PUBLISH_CONFIGURATION, publishConfiguration.getConfigurationFactoryClass())).withTypeMappings(this.override(DEFAULT_TYPE_MAPPINGS, publishConfiguration.getTypeMappings()));
        return defaulted.withContracts(publishConfiguration.getContracts().stream().map(contract -> this.transform(defaulted, (PublishContractDefinition)contract)).collect(Collectors.toList()));
    }

    private PublishContractDefinition transform(PublishConfiguration parent, PublishContractDefinition contract) {
        return contract.withNamespace(this.override(parent.getNamespace(), contract.getNamespace())).withOwner(this.override(parent.getOwner(), contract.getOwner())).withPackageName(this.override(parent.getPackageName(), contract.getPackageName())).withConfigurationFactoryClass(this.override(parent.getConfigurationFactoryClass(), contract.getConfigurationFactoryClass())).withTypeMappings(this.override(parent.getTypeMappings(), contract.getTypeMappings()));
    }

    private ProcessConfiguration transform(Definition definition, ProcessConfiguration processConfiguration) {
        ProcessConfiguration defaulted = processConfiguration.withSourceCodeConfiguration(this.override(DEFAULT_SOURCE_CODE_CONFIGURATION, processConfiguration.getSourceCodeConfiguration())).withSourceCodeProvider(this.override(DEFAULT_SOURCE_CODE_PROVIDER, processConfiguration.getSourceCodeProvider()));
        return defaulted.withContracts(processConfiguration.getContracts().stream().map(contract -> this.transform(defaulted, (ProcessContractDefinition)contract)).collect(Collectors.toList()));
    }

    private ProcessContractDefinition transform(ProcessConfiguration parent, ProcessContractDefinition contract) {
        return contract.withNamespace(this.override(parent.getNamespace(), contract.getNamespace())).withOwner(this.override(parent.getOwner(), contract.getOwner())).withSourceCodeProvider(this.override(parent.getSourceCodeProvider(), contract.getSourceCodeProvider())).withSourceCodeConfiguration(this.override(parent.getSourceCodeConfiguration(), contract.getSourceCodeConfiguration()));
    }

    private String override(String ... value) {
        List values = Arrays.asList(value).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return values.size() > 0 ? (String)values.get(values.size() - 1) : null;
    }

    private Map<String, String> override(Map<String, String> ... targets) {
        List values = Arrays.asList(targets).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (values.size() > 0) {
            HashMap<String, String> merged = new HashMap<String, String>();
            for (Map target : values) {
                merged.putAll(target);
            }
            return merged;
        }
        return Collections.emptyMap();
    }

    static {
        DEFAULT_TYPE_MAPPINGS.put("java.time.LocalDateTime", "datetime-local");
        DEFAULT_TYPE_MAPPINGS.put("java.time.OffsetDateTime", "datetime");
        DEFAULT_TYPE_MAPPINGS.put("java.time.LocalDate", "date");
        DEFAULT_TYPE_MAPPINGS.put("org.joda.time.LocalDate", "date");
    }
}

