/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.JsonSchemaDraft;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import io.bindingz.api.client.ContractService;
import io.bindingz.api.client.context.definition.model.PublishContractDefinition;
import io.bindingz.api.client.jackson.DefaultPublishConfigurationFactory;
import io.bindingz.api.model.ContractDto;
import io.bindingz.api.model.ContractSchema;
import io.bindingz.api.model.JsonSchemaSpec;
import io.bindingz.context.jackson.PublishConfigurationFactory;
import io.bindingz.context.loader.TypeScanner;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JacksonContractService
implements ContractService {
    private final TypeScanner typeScanner;

    public JacksonContractService(TypeScanner typeScanner) {
        this.typeScanner = typeScanner;
    }

    @Override
    public Collection<ContractDto> create(List<PublishContractDefinition> contracts) {
        return contracts.stream().map(this::createResource).collect(Collectors.toList());
    }

    private ContractDto createResource(PublishContractDefinition contract) {
        try {
            Map<JsonSchemaSpec, JsonNode> schemas = this.createSchemas(contract);
            return new ContractDto(contract.getNamespace(), contract.getOwner(), contract.getContractName(), contract.getVersion(), new ContractSchema(schemas));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create schema for " + contract.getClassName(), e);
        }
    }

    private Map<JsonSchemaSpec, JsonNode> createSchemas(PublishContractDefinition contract) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        HashMap<JsonSchemaSpec, JsonNode> schemas = new HashMap<JsonSchemaSpec, JsonNode>();
        Class<? extends PublishConfigurationFactory> configurationFactoryClass = this.getPublishConfigurationFactory(contract);
        PublishConfigurationFactory publishConfigurationFactory = configurationFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        JsonSchemaGenerator generator = new JsonSchemaGenerator(publishConfigurationFactory.objectMapper(this.typeScanner), this.createConfig(contract.getTypeMappings()));
        String fullClassName = String.format("%s.%s", contract.getPackageName(), contract.getClassName());
        schemas.put(JsonSchemaSpec.DRAFT_04, generator.generateJsonSchema(this.typeScanner.getClass(fullClassName)));
        return schemas;
    }

    private Class<? extends PublishConfigurationFactory> getPublishConfigurationFactory(PublishContractDefinition contract) {
        Class configurationFactoryClass = DefaultPublishConfigurationFactory.class.getName().equals(contract.getConfigurationFactoryClass()) ? DefaultPublishConfigurationFactory.class : this.typeScanner.getClass(contract.getConfigurationFactoryClass());
        return configurationFactoryClass;
    }

    private JsonSchemaConfig createConfig(Map<String, String> customTypesToFormats) {
        JsonSchemaConfig config = JsonSchemaConfig.create((boolean)false, Optional.empty(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, customTypesToFormats, (boolean)false, new HashSet<Class>(Arrays.asList(scala.collection.immutable.Set.class, scala.collection.mutable.Set.class, Set.class)), Collections.emptyMap(), Collections.emptyMap(), null, (boolean)true, null);
        return config.withJsonSchemaDraft(this.version(JsonSchemaSpec.DRAFT_04));
    }

    private JsonSchemaDraft version(JsonSchemaSpec spec) {
        return JsonSchemaDraft.valueOf((String)spec.name());
    }
}

