/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.agent.RemoteClient;
import org.openjdk.btrace.agent.TraceOutputWriter;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.comm.ErrorCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.MessageCommand;
import org.openjdk.btrace.core.comm.RenameCommand;
import org.openjdk.btrace.core.comm.RetransformationStartNotification;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeFactory;
import org.openjdk.btrace.instr.BTraceProbePersisted;
import org.openjdk.btrace.instr.BTraceTransformer;
import org.openjdk.btrace.instr.ClassCache;
import org.openjdk.btrace.instr.ClassFilter;
import org.openjdk.btrace.instr.ClassInfo;
import org.openjdk.btrace.instr.HandlerRepositoryImpl;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Instrumentor;
import org.openjdk.btrace.instr.templates.impl.MethodTrackingExpander;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;
import org.openjdk.btrace.runtime.BTraceRuntimes;

abstract class Client
implements CommandListener {
    private static final Map<UUID, Client> CLIENTS = new ConcurrentHashMap<UUID, Client>();
    private static final Map<String, PrintWriter> WRITER_MAP = new HashMap<String, PrintWriter>();
    private static final Pattern SYSPROP_PTN = Pattern.compile("\\$\\{(.+?)}");
    private final Instrumentation inst;
    final SharedSettings settings;
    final DebugSupport debug;
    final ArgsMap argsMap;
    private final BTraceTransformer transformer;
    volatile PrintWriter out;
    private volatile BTraceRuntime.Impl runtime;
    private volatile String outputName;
    private BTraceProbe probe;
    private Timer flusher;
    private volatile boolean initialized = false;
    private volatile boolean shuttingDown = false;
    final UUID id = UUID.randomUUID();

    Client(ClientContext ctx) {
        this(ctx.getInstr(), ctx.getArguments(), ctx.getSettings(), ctx.getTransformer());
    }

    private Client(Instrumentation inst, ArgsMap argsMap, SharedSettings s, BTraceTransformer t) {
        this.inst = inst;
        this.argsMap = argsMap;
        this.settings = s != null ? s : SharedSettings.GLOBAL;
        this.transformer = t;
        this.debug = new DebugSupport(this.settings);
        this.setupWriter();
        CLIENTS.put(this.id, this);
    }

    private static String pid() {
        String[] parts;
        String pName = ManagementFactory.getRuntimeMXBean().getName();
        if (pName != null && pName.length() > 0 && (parts = pName.split("@")).length == 2) {
            return parts[0];
        }
        return "-1";
    }

    protected final void initialize() {
        this.initialized = true;
    }

    private final void setupWriter() {
        String outputFile = this.settings.getOutputFile();
        if (outputFile == null || outputFile.equals("::null") || outputFile.equals("/dev/null")) {
            return;
        }
        if (!outputFile.equals("::stdout")) {
            String outputDir = this.settings.getOutputDir();
            String output = (outputDir != null ? outputDir + File.separator : "") + outputFile;
            outputFile = this.templateOutputFileName(output);
            this.infoPrint("Redirecting output to " + outputFile);
        }
        this.out = WRITER_MAP.get(outputFile);
        if (this.out == null) {
            this.out = outputFile.equals("::stdout") ? new PrintWriter(System.out) : (this.settings.getFileRollMilliseconds() > 0 ? new PrintWriter(new BufferedWriter(TraceOutputWriter.rollingFileWriter(new File(outputFile), this.settings))) : new PrintWriter(new BufferedWriter(TraceOutputWriter.fileWriter(new File(outputFile), this.settings))));
            WRITER_MAP.put(outputFile, this.out);
            this.out.append("### BTrace Log: ").append(DateFormat.getInstance().format(new Date())).append("\n\n");
            this.startFlusher();
        }
        this.outputName = outputFile;
    }

    private void startFlusher() {
        int flushInterval;
        String flushIntervalStr = System.getProperty("org.openjdk.btrace.FileClient.flush");
        if (flushIntervalStr == null) {
            flushIntervalStr = System.getProperty("com.sun.btrace.FileClient.flush", "5");
        }
        try {
            flushInterval = Integer.parseInt(flushIntervalStr);
        }
        catch (NumberFormatException e) {
            flushInterval = 5;
        }
        int flushSec = flushInterval;
        if (flushSec > -1) {
            this.flusher = new Timer("BTrace FileClient Flusher", true);
            this.flusher.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (Client.this.out == null) break block6;
                            boolean entered = BTraceRuntime.enter();
                            try {
                                Client.this.out.flush();
                            }
                            finally {
                                if (entered) {
                                    BTraceRuntime.leave();
                                }
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }, flushSec, (long)flushSec);
        } else {
            this.flusher = null;
        }
    }

    private String templateOutputFileName(String fName) {
        if (fName != null) {
            boolean dflt = fName.contains("[default]");
            String agentName = System.getProperty("btrace.agent", "default");
            String clientName = this.settings.getClientName();
            fName = fName.replace("${client}", clientName != null ? clientName : "").replace("${ts}", String.valueOf(System.currentTimeMillis())).replace("${pid}", Client.pid()).replace("${agent}", agentName != null ? "." + agentName : "").replace("[default]", "");
            fName = this.replaceSysProps(fName);
            if (dflt && this.settings.isDebug()) {
                this.debugPrint("scriptOutputFile not specified. defaulting to " + fName);
            }
        }
        return fName;
    }

    private String replaceSysProps(String str) {
        int replaced = 0;
        do {
            StringBuffer sb = new StringBuffer();
            replaced = this.replaceSysProps(str, sb);
            str = sb.toString();
        } while (replaced > 0);
        return str;
    }

    private int replaceSysProps(String str, StringBuffer sb) {
        int cnt = 0;
        Matcher m = SYSPROP_PTN.matcher(str);
        while (m.find()) {
            String key = m.group(1);
            String val = System.getProperty(key);
            if (val != null) {
                ++cnt;
                m.appendReplacement(sb, val);
                continue;
            }
            m.appendReplacement(sb, m.group(0));
        }
        m.appendTail(sb);
        return cnt;
    }

    static Collection<String> listProbes() {
        ArrayList<String> probes = new ArrayList<String>(CLIENTS.size());
        for (Client client : CLIENTS.values()) {
            if (!(client instanceof RemoteClient) || !((RemoteClient)client).isDisconnected()) continue;
            probes.add(client.id + " [" + client.getClassName() + "]");
        }
        return probes;
    }

    synchronized void onExit(int exitCode) {
        if (!this.shuttingDown) {
            this.shuttingDown = true;
            if (this.out != null) {
                this.out.flush();
            }
            BTraceRuntime.leave();
            try {
                this.debugPrint("onExit:");
                this.debugPrint("cleaning up transformers");
                this.cleanupTransformers();
                this.debugPrint("removing instrumentation");
                this.retransformLoaded();
                this.debugPrint("closing all I/O");
                Thread.sleep(300L);
                try {
                    this.closeAll();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.debugPrint("done");
            }
            catch (Throwable th) {
                if (!th.getClass().getName().equals("ExitException")) {
                    this.debugPrint(th);
                    BTraceRuntime.handleException((Throwable)th);
                }
            }
            finally {
                this.runtime.shutdownCmdLine();
                CLIENTS.remove(this.id);
                HandlerRepositoryImpl.unregisterProbe(this.probe);
            }
        }
    }

    final Class<?> loadClass(InstrumentCommand instr) throws IOException {
        return this.loadClass(instr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> loadClass(InstrumentCommand instr, boolean canLoadPack) throws IOException {
        ArgsMap args = instr.getArguments();
        byte[] btraceCode = instr.getCode();
        try {
            this.probe = this.load(btraceCode, ArgsMap.merge((ArgsMap[])new ArgsMap[]{this.argsMap, args}), canLoadPack);
            if (this.probe == null) {
                this.debugPrint("Failed to load BTrace probe code");
                return null;
            }
            if (!this.settings.isTrusted()) {
                this.probe.checkVerified();
            }
        }
        catch (Throwable th) {
            this.debugPrint(th);
            this.errorExit(th);
            return null;
        }
        if (this.probe.isClassRenamed()) {
            if (this.isDebug()) {
                this.debugPrint("class renamed to " + this.probe.getClassName());
            }
            this.onCommand((Command)new RenameCommand(this.probe.getClassName()));
        }
        if (this.isDebug()) {
            this.debugPrint("creating BTraceRuntime instance for " + this.probe.getClassName());
        }
        this.runtime = BTraceRuntimes.getRuntime((String)this.probe.getClassName(), (ArgsMap)args, (CommandListener)this, (DebugSupport)this.debug, (Instrumentation)this.inst);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.runtime != null) {
                this.runtime.handleExit(0);
            }
        }));
        if (this.isDebug()) {
            this.debugPrint("created BTraceRuntime instance for " + this.probe.getClassName());
            this.debugPrint("sending Okay command");
        }
        this.onCommand((Command)new StatusCommand());
        boolean entered = false;
        try {
            entered = BTraceRuntimeAccess.enter((BTraceRuntime.Impl)this.runtime);
            Class<?> clazz = this.probe.register(this.runtime, this.transformer);
            return clazz;
        }
        catch (Throwable th) {
            this.debugPrint(th);
            this.errorExit(th);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            if (entered) {
                BTraceRuntime.leave();
            }
        }
    }

    protected void closeAll() throws IOException {
        if (this.flusher != null) {
            this.flusher.cancel();
        }
        if (this.out != null) {
            this.out.close();
        }
        WRITER_MAP.remove(this.outputName);
    }

    private void errorExit(Throwable th) throws IOException {
        this.debugPrint("sending error command");
        this.onCommand((Command)new ErrorCommand(th));
        this.debugPrint("sending exit command");
        this.onCommand((Command)new ExitCommand(1));
        this.closeAll();
    }

    private void cleanupTransformers() {
        if (this.probe != null) {
            this.probe.unregister();
        }
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    private void infoPrint(String msg) {
        DebugSupport.info((String)msg);
    }

    final boolean isDebug() {
        return this.settings.isDebug();
    }

    final void debugPrint(String msg) {
        this.debug.debug(msg);
    }

    final void debugPrint(Throwable th) {
        this.debug.debug(th);
    }

    final BTraceRuntime.Impl getRuntime() {
        return this.runtime;
    }

    final String getClassName() {
        return this.probe != null ? this.probe.getClassName() : "<unknown>";
    }

    private final boolean isCandidate(Class<?> c) {
        String cname = c.getName().replace('.', '/');
        if (c.isInterface() || c.isPrimitive() || c.isArray()) {
            return false;
        }
        if (ClassFilter.isSensitiveClass(cname)) {
            return false;
        }
        return this.probe.willInstrument(c);
    }

    private final void startRetransformClasses(int numClasses) {
        try {
            this.onCommand((Command)new RetransformationStartNotification(numClasses));
            if (this.isDebug()) {
                this.debugPrint("calling retransformClasses (" + numClasses + " classes to be retransformed)");
            }
        }
        catch (IOException e) {
            this.debugPrint(e);
        }
    }

    final void endRetransformClasses() {
        try {
            this.onCommand((Command)new StatusCommand());
            if (this.isDebug()) {
                this.debugPrint("finished retransformClasses");
            }
        }
        catch (IOException e) {
            this.debugPrint(e);
        }
    }

    private BTraceProbe load(byte[] buf, ArgsMap args, boolean canLoadPack) {
        BTraceProbeFactory f = new BTraceProbeFactory(this.settings, canLoadPack);
        this.debugPrint("loading BTrace class");
        BTraceProbe cn = f.createProbe(buf, args);
        if (cn != null && this.isDebug()) {
            if (cn.isVerified()) {
                this.debugPrint("loaded '" + cn.getClassName() + "' successfully");
            } else {
                this.debugPrint(cn.getClassName() + " failed verification");
                return null;
            }
        }
        return BTraceProbePersisted.from(cn);
    }

    boolean retransformLoaded() throws UnmodifiableClassException {
        block17: {
            if (this.runtime == null) {
                return false;
            }
            if (!this.probe.isTransforming() || !this.settings.isRetransformStartup()) break block17;
            ArrayList<Class> list = new ArrayList<Class>();
            this.debugPrint("retransforming loaded classes");
            this.debugPrint("filtering loaded classes");
            ClassCache cc = ClassCache.getInstance();
            for (Class c : this.inst.getAllLoadedClasses()) {
                if (c == null || !this.inst.isModifiableClass(c) || !this.isCandidate(c)) continue;
                this.debugPrint("candidate " + c + " added");
                list.add(c);
            }
            list.trimToSize();
            int size = list.size();
            if (size > 0) {
                Class[] classes = new Class[size];
                list.toArray(classes);
                this.startRetransformClasses(size);
                if (this.isDebug()) {
                    for (Class c : classes) {
                        try {
                            this.debugPrint("Attempting to retransform class: " + c.getName());
                            this.inst.retransformClasses(c);
                        }
                        catch (VerifyError e) {
                            this.debugPrint(e);
                            try {
                                this.onCommand((Command)new MessageCommand("[BTRACE WARN] Class verification failed: " + c.getName() + " (" + e.getMessage() + ")"));
                            }
                            catch (IOException ioException) {
                                if (!this.isDebug()) continue;
                                this.debug.debug((Throwable)ioException);
                            }
                        }
                    }
                } else {
                    try {
                        this.inst.retransformClasses(classes);
                    }
                    catch (VerifyError e) {
                        for (Class c : classes) {
                            try {
                                this.inst.retransformClasses(c);
                            }
                            catch (VerifyError e1) {
                                this.debugPrint(e1);
                                try {
                                    this.onCommand((Command)new MessageCommand("[BTRACE WARN] Class verification failed: " + c.getName() + " (" + e.getMessage() + ")"));
                                }
                                catch (IOException ioException) {
                                    if (!this.isDebug()) continue;
                                    this.debug.debug((Throwable)ioException);
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    static Client findClient(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            return CLIENTS.get(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return "BTrace Client: " + this.id + "[" + this.probe.getClassName() + "]";
    }

    static {
        ClassFilter.class.getClassLoader();
        InstrumentUtils.class.getClassLoader();
        Instrumentor.class.getClassLoader();
        ClassReader.class.getClassLoader();
        ClassWriter.class.getClassLoader();
        Annotation.class.getClassLoader();
        MethodTrackingExpander.class.getClassLoader();
        ClassCache.class.getClassLoader();
        ClassInfo.class.getClassLoader();
    }
}

