/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import org.openjdk.btrace.agent.Client;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.CircularBuffer;
import org.openjdk.btrace.core.Function;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.DisconnectCommand;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.ListProbesCommand;
import org.openjdk.btrace.core.comm.PrintableCommand;
import org.openjdk.btrace.core.comm.ReconnectCommand;
import org.openjdk.btrace.core.comm.SetSettingsCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.core.comm.WireIO;

class RemoteClient
extends Client {
    private volatile Socket sock;
    private volatile ObjectInputStream ois;
    private volatile ObjectOutputStream oos;
    private final CircularBuffer<Command> delayedCommands = new CircularBuffer(5000);

    static Client getClient(ClientContext ctx, Socket sock, Function<Client, Future<?>> initCallback) throws IOException {
        Command cmd;
        ObjectInputStream ois = new ObjectInputStream(sock.getInputStream());
        ObjectOutputStream oos = new ObjectOutputStream(sock.getOutputStream());
        SharedSettings settings = new SharedSettings();
        block9: while (true) {
            cmd = WireIO.read((ObjectInput)ois);
            switch (cmd.getType()) {
                case 13: {
                    settings.from(((SetSettingsCommand)cmd).getParams());
                    continue block9;
                }
                case 3: {
                    Client client;
                    try {
                        client = new RemoteClient(ctx, ois, oos, sock, (InstrumentCommand)cmd, settings);
                        ((Future)initCallback.apply((Object)client)).get();
                        WireIO.write((ObjectOutput)oos, (Command)new StatusCommand(1));
                        return client;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        WireIO.write((ObjectOutput)oos, (Command)new StatusCommand(-1));
                        throw new IOException(e);
                    }
                }
                case 16: {
                    Client client = Client.findClient(((ReconnectCommand)cmd).getProbeId());
                    if (client instanceof RemoteClient) {
                        ((RemoteClient)client).reconnect(ois, oos, sock);
                        WireIO.write((ObjectOutput)oos, (Command)new StatusCommand(8));
                        return client;
                    }
                    WireIO.write((ObjectOutput)oos, (Command)new StatusCommand(-8));
                    throw new IOException("Can not reconnect to non-remote session");
                }
                case 14: {
                    ListProbesCommand listProbesCommand = (ListProbesCommand)cmd;
                    listProbesCommand.setProbes(Client.listProbes());
                    WireIO.write((ObjectOutput)oos, (Command)listProbesCommand);
                    continue block9;
                }
                case 2: {
                    return null;
                }
            }
            break;
        }
        throw new IOException("expecting instrument, reconnect or settings command! (" + cmd.getClass() + ")");
    }

    private RemoteClient(ClientContext ctx, ObjectInputStream ois, ObjectOutputStream oos, Socket sock, InstrumentCommand cmd, SharedSettings settings) throws IOException {
        super(ctx);
        this.sock = sock;
        this.ois = ois;
        this.oos = oos;
        this.settings.from(settings);
        this.debugPrint("got instrument command");
        Class<?> btraceClazz = this.loadClass(cmd);
        if (btraceClazz == null) {
            throw new RuntimeException("can not load BTrace class");
        }
        this.initClient();
    }

    private void initClient() {
        BTraceRuntime.initUnsafe();
        Thread cmdHandler = new Thread(() -> {
            try {
                BTraceRuntime.enter();
                try {
                    block13: while (true) {
                        if (this.ois == null) {
                            LockSupport.parkNanos(500000000L);
                            continue;
                        }
                        Command cmd = WireIO.read((ObjectInput)this.ois);
                        switch (cmd.getType()) {
                            case 2: {
                                this.debugPrint("received exit command");
                                this.onCommand(cmd);
                                return;
                            }
                            case 15: {
                                this.debugPrint("received disconnect command");
                                this.onCommand(cmd);
                                continue block13;
                            }
                            case 14: {
                                this.onCommand(cmd);
                                continue block13;
                            }
                            case 1: {
                                this.getRuntime().handleEvent((EventCommand)cmd);
                                continue block13;
                            }
                        }
                        if (!this.isDebug()) continue;
                        this.debugPrint("received " + cmd);
                    }
                }
                catch (Exception exp) {
                    this.debugPrint(exp);
                    BTraceRuntime.leave();
                    return;
                }
            }
            finally {
                BTraceRuntime.leave();
            }
        });
        cmdHandler.setDaemon(true);
        this.debugPrint("starting client command handler thread");
        cmdHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Command cmd) throws IOException {
        if (this.oos == null) {
            if (!cmd.isUrgent()) {
                this.delayedCommands.add((Object)cmd);
            }
            return;
        }
        if (this.isDebug()) {
            this.debugPrint("client " + this.getClassName() + ": got " + cmd);
        }
        try {
            boolean isConnected = true;
            try {
                ObjectOutputStream objectOutputStream = this.oos;
                synchronized (objectOutputStream) {
                    this.oos.reset();
                }
            }
            catch (SocketException e) {
                isConnected = false;
            }
            this.delayedCommands.forEach((Function)new DelayedCommandExecutor(isConnected));
            if (!this.dispatchCommand(cmd, isConnected) && !cmd.isUrgent()) {
                this.delayedCommands.add((Object)cmd);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchCommand(Command cmd, boolean isConnected) {
        if (cmd == Command.NULL) {
            return true;
        }
        try {
            switch (cmd.getType()) {
                case 2: {
                    if (isConnected) {
                        WireIO.write((ObjectOutput)this.oos, (Command)cmd);
                    }
                    this.onExit(((ExitCommand)cmd).getExitCode());
                    break;
                }
                case 14: {
                    if (!isConnected) break;
                    ((ListProbesCommand)cmd).setProbes(RemoteClient.listProbes());
                    WireIO.write((ObjectOutput)this.oos, (Command)cmd);
                    break;
                }
                case 15: {
                    ((DisconnectCommand)cmd).setProbeId(this.id.toString());
                    ObjectOutputStream objectOutputStream = this.oos;
                    synchronized (objectOutputStream) {
                        WireIO.write((ObjectOutput)this.oos, (Command)cmd);
                        this.oos.flush();
                        this.ois.close();
                        this.oos.close();
                    }
                    this.sock.close();
                    this.ois = null;
                    this.oos = null;
                    this.sock = null;
                    break;
                }
                default: {
                    if (this.out != null && cmd instanceof PrintableCommand) {
                        ((PrintableCommand)cmd).print(this.out);
                        break;
                    }
                    if (!isConnected) break;
                    WireIO.write((ObjectOutput)this.oos, (Command)cmd);
                }
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDisconnected() {
        return this.sock == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void closeAll() throws IOException {
        super.closeAll();
        if (this.oos != null) {
            ObjectOutputStream objectOutputStream = this.oos;
            synchronized (objectOutputStream) {
                this.oos.close();
            }
            this.oos = null;
        }
        if (this.ois != null) {
            this.ois.close();
            this.ois = null;
        }
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    void reconnect(ObjectInputStream ois, ObjectOutputStream oos, Socket socket) throws IOException {
        this.sock = socket;
        this.ois = ois;
        this.oos = oos;
        this.onCommand(Command.NULL);
    }

    private final class DelayedCommandExecutor
    implements Function<Command, Boolean> {
        private final boolean isConnected;

        public DelayedCommandExecutor(boolean isConnected) {
            this.isConnected = isConnected;
        }

        public Boolean apply(Command value) {
            return RemoteClient.this.dispatchCommand(value, this.isConnected);
        }
    }
}

