/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.SharedSettings;

abstract class TraceOutputWriter
extends Writer {
    protected final DebugSupport debug;

    protected TraceOutputWriter(SharedSettings settings) {
        this.debug = new DebugSupport(settings);
    }

    public static TraceOutputWriter fileWriter(File output, SharedSettings settings) {
        SimpleFileOutput instance = null;
        try {
            instance = new SimpleFileOutput(output, settings);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return instance;
    }

    public static TraceOutputWriter rollingFileWriter(File output, SharedSettings settings) {
        TimeBasedRollingFileWriter instance = null;
        try {
            instance = new TimeBasedRollingFileWriter(output, settings);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return instance;
    }

    private static void ensurePathExists(File f) {
        if (f == null || f.exists()) {
            return;
        }
        TraceOutputWriter.ensurePathExists(f.getParentFile());
        if (!f.getName().endsWith(".btrace")) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TimeBasedRollingFileWriter
    extends RollingFileWriter {
        private final TimeUnit unit = TimeUnit.MILLISECONDS;
        private long lastTimeStamp = System.currentTimeMillis();

        public TimeBasedRollingFileWriter(File output, SharedSettings settings) throws IOException {
            super(output, settings);
        }

        @Override
        protected boolean needsRoll() {
            long currTime = System.currentTimeMillis();
            long myInterval = currTime - this.lastTimeStamp;
            if (this.unit.convert(myInterval, TimeUnit.MILLISECONDS) >= (long)this.settings.getFileRollMilliseconds()) {
                this.lastTimeStamp = currTime;
                return true;
            }
            return false;
        }
    }

    private static abstract class RollingFileWriter
    extends TraceOutputWriter {
        protected final SharedSettings settings;
        private final ReentrantReadWriteLock writerLock = new ReentrantReadWriteLock();
        private final String path;
        private final String baseName;
        private FileWriter currentFileWriter;
        private int counter = 1;

        public RollingFileWriter(File output, SharedSettings settings) throws IOException {
            super(settings);
            try {
                output.getParentFile().mkdirs();
                this.currentFileWriter = new FileWriter(output);
                this.path = output.getParentFile().getAbsolutePath();
                this.baseName = output.getName();
                this.settings = settings;
            }
            catch (IOException e) {
                this.debug.debug((Throwable)e);
                throw e;
            }
        }

        @Override
        public final void close() throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.close();
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }

        @Override
        public final void flush() throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.flush();
            }
            finally {
                this.writerLock.readLock().unlock();
            }
            if (this.needsRoll()) {
                this.nextWriter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.write(cbuf, off, len);
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }

        private void nextWriter() {
            try {
                this.writerLock.writeLock().lock();
                this.currentFileWriter = this.getNextWriter();
            }
            catch (IOException e) {
                this.debug.debug((Throwable)e);
            }
            finally {
                this.writerLock.writeLock().unlock();
            }
        }

        private FileWriter getNextWriter() throws IOException {
            this.currentFileWriter.close();
            File scriptOutputFile_renameFrom = new File(this.path + File.separator + this.baseName);
            File scriptOutputFile_renameTo = new File(this.path + File.separator + this.baseName + "." + this.counter++);
            if (scriptOutputFile_renameTo.exists()) {
                scriptOutputFile_renameTo.delete();
            }
            scriptOutputFile_renameFrom.renameTo(scriptOutputFile_renameTo);
            scriptOutputFile_renameFrom = new File(this.path + File.separator + this.baseName);
            if (this.counter > this.settings.getFileRollMaxRolls()) {
                this.counter = 1;
            }
            return new FileWriter(scriptOutputFile_renameFrom);
        }

        protected abstract boolean needsRoll();
    }

    private static class SimpleFileOutput
    extends TraceOutputWriter {
        private final FileWriter delegate;

        public SimpleFileOutput(File output, SharedSettings settings) throws IOException {
            super(settings);
            try {
                File parent = output.getParentFile();
                if (parent != null) {
                    output.getParentFile().mkdirs();
                }
                this.delegate = new FileWriter(output);
            }
            catch (IOException e) {
                this.debug.debug((Throwable)e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }
    }
}

