/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.SharedSettings;

final class BTraceBCPClassLoader
extends URLClassLoader {
    BTraceBCPClassLoader(SharedSettings settings) {
        super(BTraceBCPClassLoader.getBCPUrls(settings), (ClassLoader)null);
    }

    private static URL[] getBCPUrls(SharedSettings settings) {
        DebugSupport debug = new DebugSupport(settings);
        String bcp = settings.getBootClassPath();
        if (bcp != null && !bcp.isEmpty()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String cpElement : bcp.split(File.pathSeparator)) {
                try {
                    urls.add(new File(cpElement).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    debug.debug((Throwable)e);
                }
            }
            return urls.toArray(new URL[0]);
        }
        return new URL[0];
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }
}

