/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Instrumentor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;

final class BTraceClassWriter
extends ClassWriter {
    private final Deque<Instrumentor> instrumentors = new ArrayDeque<Instrumentor>();
    private final ClassLoader targetCL;
    private final BTraceClassReader cr;
    private final Collection<MethodNode> cushionMethods = new HashSet<MethodNode>();

    BTraceClassWriter(ClassLoader cl, int flags) {
        super(flags);
        this.targetCL = cl != null ? cl : ClassLoader.getSystemClassLoader();
        this.cr = null;
    }

    BTraceClassWriter(ClassLoader cl, BTraceClassReader reader, int flags) {
        super((ClassReader)reader, flags);
        this.targetCL = cl != null ? cl : ClassLoader.getSystemClassLoader();
        this.cr = reader;
    }

    public void addInstrumentor(BTraceProbe bp) {
        this.addInstrumentor(bp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentor(BTraceProbe bp, ClassLoader cl) {
        if (this.cr != null && bp != null) {
            Deque<Instrumentor> deque = this.instrumentors;
            synchronized (deque) {
                Instrumentor top = this.instrumentors.peekLast();
                Object parent = top != null ? top : this;
                Instrumentor i = Instrumentor.create(this.cr, bp, parent, cl);
                if (i != null) {
                    this.instrumentors.add(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] instrument() {
        boolean hit = false;
        Deque<Instrumentor> deque = this.instrumentors;
        synchronized (deque) {
            if (this.instrumentors.isEmpty()) {
                return null;
            }
            final Instrumentor top = this.instrumentors.peekLast();
            ClassVisitor cv = new ClassVisitor(458752, (ClassVisitor)(top != null ? top : this)){

                public void visitEnd() {
                    if (top != null && top.hasCushionMethods()) {
                        for (MethodNode m : BTraceClassWriter.this.cushionMethods) {
                            m.accept((ClassVisitor)this);
                        }
                    }
                    super.visitEnd();
                }
            };
            InstrumentUtils.accept(this.cr, cv);
            for (Instrumentor i : this.instrumentors) {
                hit |= i.hasMatch();
            }
        }
        return hit ? this.toByteArray() : null;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        LinkedHashSet<String> type1Closure = new LinkedHashSet<String>();
        LinkedHashSet<String> type2Closure = new LinkedHashSet<String>();
        InstrumentUtils.collectHierarchyClosure(this.targetCL, type1, type1Closure, true);
        InstrumentUtils.collectHierarchyClosure(this.targetCL, type2, type2Closure, true);
        type1Closure.retainAll(type2Closure);
        Iterator iter = type1Closure.iterator();
        if (iter.hasNext()) {
            return (String)iter.next();
        }
        return "java/lang/Object";
    }

    public void addCushionMethods(Collection<MethodNode> pillowMethods) {
        this.cushionMethods.addAll(pillowMethods);
    }
}

