/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeNode;
import org.openjdk.btrace.instr.BTraceProbePersisted;
import org.openjdk.btrace.instr.HandlerRepositoryImpl;

public final class BTraceProbeFactory {
    private final SharedSettings settings;
    private final DebugSupport debug;
    private final boolean canLoadPack;

    public BTraceProbeFactory(SharedSettings settings) {
        this(settings, true);
    }

    public BTraceProbeFactory(SharedSettings settings, boolean canLoadPack) {
        this.settings = settings;
        this.debug = new DebugSupport(settings);
        this.canLoadPack = canLoadPack;
    }

    private static void applyArgs(BTraceProbe bp, ArgsMap argsMap) {
        if (bp != null && argsMap != null && !argsMap.isEmpty()) {
            bp.applyArgs(argsMap);
        }
    }

    SharedSettings getSettings() {
        return this.settings;
    }

    public BTraceProbe createProbe(byte[] code) {
        return this.createProbe(code, null);
    }

    public BTraceProbe createProbe(byte[] code, ArgsMap argsMap) {
        BTraceProbe bp = null;
        int mgc = (code[0] & 0xFF) << 24 | (code[1] & 0xFF) << 16 | (code[2] & 0xFF) << 8 | code[3] & 0xFF;
        if (mgc == -1160852790) {
            if (this.canLoadPack) {
                BTraceProbePersisted bpp = new BTraceProbePersisted(this);
                try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Arrays.copyOfRange(code, 4, code.length)));){
                    bpp.read(dis);
                    bp = bpp;
                }
                catch (IOException e) {
                    this.debug.debug((Throwable)e);
                }
            }
        } else {
            bp = new BTraceProbeNode(this, code);
        }
        BTraceProbeFactory.applyArgs(bp, argsMap);
        HandlerRepositoryImpl.registerProbe(bp);
        return bp;
    }

    public BTraceProbe createProbe(InputStream code) {
        return this.createProbe(code, null);
    }

    public BTraceProbe createProbe(InputStream code, ArgsMap argsMap) {
        BTraceProbe bp;
        block16: {
            bp = null;
            try (DataInputStream dis = new DataInputStream(code);){
                dis.mark(0);
                int mgc = dis.readInt();
                if (mgc == -1160852790) {
                    BTraceProbePersisted bpp = new BTraceProbePersisted(this);
                    bpp.read(dis);
                    bp = bpp;
                } else {
                    code.reset();
                    bp = new BTraceProbeNode(this, code);
                }
            }
            catch (IOException e) {
                if (!this.debug.isDebug()) break block16;
                this.debug.debug((Throwable)e);
            }
        }
        BTraceProbeFactory.applyArgs(bp, argsMap);
        HandlerRepositoryImpl.registerProbe(bp);
        return bp;
    }
}

