/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.BTraceClassWriter;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.ClassFilter;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Instrumentor;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.AbstractInsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.InsnList;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.InsnNode;
import org.openjdk.btrace.libs.org.objectweb.asm.tree.MethodNode;

public final class BTraceTransformer
implements ClassFileTransformer {
    private final DebugSupport debug;
    private final ReentrantReadWriteLock setupLock = new ReentrantReadWriteLock();
    private final Collection<BTraceProbe> probes = new ArrayList<BTraceProbe>(3);
    private final Filter filter = new Filter();
    private final Collection<MethodNode> cushionMethods = new HashSet<MethodNode>();

    public BTraceTransformer(DebugSupport d) {
        this.debug = d;
    }

    private static boolean isSensitiveClass(String name) {
        return ClassFilter.isSensitiveClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(BTraceProbe p) {
        try {
            this.setupLock.writeLock().lock();
            this.probes.add(p);
            for (OnMethod om : p.onmethods()) {
                this.filter.add(om);
            }
        }
        finally {
            this.setupLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister(BTraceProbe p) {
        try {
            this.setupLock.writeLock().lock();
            this.probes.remove(p);
            for (OnMethod om : p.onmethods()) {
                this.filter.remove(om);
                MethodNode cushionMethod = new MethodNode(458752, 10, Instrumentor.getActionMethodName(p, om.getTargetName()), om.getTargetDescriptor(), null, null);
                InsnList code = new InsnList();
                code.add((AbstractInsnNode)new InsnNode(177));
                cushionMethod.instructions = code;
                int localSize = 0;
                for (Type t : Type.getArgumentTypes((String)om.getTargetDescriptor())) {
                    localSize += t.getSize();
                }
                cushionMethod.maxLocals = localSize;
                this.cushionMethods.add(cushionMethod);
            }
        }
        finally {
            this.setupLock.writeLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            byte[] byArray;
            this.setupLock.readLock().lock();
            if (this.probes.isEmpty()) {
                byte[] byArray2 = null;
                return byArray2;
            }
            String string = className = className != null ? className : "<anonymous>";
            if ((loader == null || loader.equals(ClassLoader.getSystemClassLoader())) && BTraceTransformer.isSensitiveClass(className)) {
                if (this.isDebug()) {
                    this.debugPrint("skipping transform for BTrace class " + className);
                }
                byte[] byArray3 = null;
                return byArray3;
            }
            if (this.filter.matchClass(className) == Filter.Result.FALSE) {
                byte[] byArray4 = null;
                return byArray4;
            }
            boolean entered = BTraceRuntime.enter();
            try {
                if (this.isDebug()) {
                    this.debug.dumpClass(className.replace('.', '/') + "_orig", classfileBuffer);
                }
                BTraceClassReader cr = InstrumentUtils.newClassReader(loader, classfileBuffer);
                BTraceClassWriter cw = InstrumentUtils.newClassWriter(cr);
                cw.addCushionMethods(this.cushionMethods);
                for (BTraceProbe p : this.probes) {
                    p.notifyTransform(className);
                    cw.addInstrumentor(p, loader);
                }
                byte[] transformed = cw.instrument();
                if (transformed == null) {
                    if (this.isDebug()) {
                        this.debugPrint("skipping class " + cr.getJavaClassName());
                    }
                    byArray = classfileBuffer;
                    return byArray;
                }
                if (this.isDebug()) {
                    this.debugPrint("transformed class " + cr.getJavaClassName());
                }
                if (this.debug.isDumpClasses()) {
                    this.debug.dumpClass(className.replace('.', '/'), transformed);
                }
                byArray = transformed;
            }
            catch (Throwable th) {
                this.debugPrint(th);
                throw th;
            }
            finally {
                if (entered) {
                    BTraceRuntime.leave();
                }
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.setupLock.readLock().unlock();
        }
    }

    private boolean isDebug() {
        return this.debug.isDebug();
    }

    private void debugPrint(String msg) {
        this.debug.debug(msg);
    }

    private void debugPrint(Throwable th) {
        this.debug.debug(th);
    }

    static class Filter {
        private final Map<String, Integer> nameMap = new HashMap<String, Integer>();
        private final Map<Pattern, Integer> nameRegexMap = new HashMap<Pattern, Integer>();
        private boolean isFast = true;
        private boolean isRegex = false;

        Filter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <K> void addToMap(Map<K, Integer> map, K name) {
            Map<K, Integer> map2 = map;
            synchronized (map2) {
                map.merge(name, 1, Integer::sum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <K> void removeFromMap(Map<K, Integer> map, K name) {
            Map<K, Integer> map2 = map;
            synchronized (map2) {
                Integer i = map.get(name);
                if (i == null) {
                    return;
                }
                int freq = i - 1;
                if (freq == 0) {
                    map.remove(name);
                }
            }
        }

        void add(OnMethod om) {
            if (om.isSubtypeMatcher() || om.isClassAnnotationMatcher()) {
                this.isFast = false;
            } else if (om.isClassRegexMatcher()) {
                this.isRegex = true;
                String name = om.getClazz().replace("\\.", "/");
                Filter.addToMap(this.nameRegexMap, Pattern.compile(name));
            } else {
                String name = om.getClazz().replace('.', '/');
                Filter.addToMap(this.nameMap, name);
            }
        }

        void remove(OnMethod om) {
            String name = om.getClazz().replace('.', '/');
            if (!om.isSubtypeMatcher() && !om.isClassAnnotationMatcher()) {
                if (om.isClassRegexMatcher()) {
                    Filter.removeFromMap(this.nameRegexMap, Pattern.compile(name));
                } else {
                    Filter.removeFromMap(this.nameMap, name);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result matchClass(String className) {
            if (this.isFast) {
                Map<Object, Integer> map = this.nameMap;
                synchronized (map) {
                    if (this.nameMap.containsKey(className)) {
                        return Result.TRUE;
                    }
                }
                if (this.isRegex) {
                    map = this.nameRegexMap;
                    synchronized (map) {
                        for (Pattern p : this.nameRegexMap.keySet()) {
                            if (!p.matcher(className).matches()) continue;
                            return Result.TRUE;
                        }
                    }
                }
                return Result.FALSE;
            }
            return Result.MAYBE;
        }

        static enum Result {
            TRUE,
            FALSE,
            MAYBE;

        }
    }
}

