/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

public class CatchInstrumentor
extends MethodInstrumentor {
    private final Map<Label, String> handlers = new HashMap<Label, String>();

    public CatchInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        String catchType = this.handlers.get(label);
        if (catchType != null) {
            this.insertFrameReplaceStack(label, Type.getObjectType((String)catchType));
            this.onCatch(catchType);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.handlers.put(handler, type);
        }
        super.visitTryCatchBlock(start, end, handler, type);
    }

    protected void onCatch(String type) {
        this.asm.println("catching " + type);
    }
}

